/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.security;

import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;


/**
 * Utility for evaluating expression which is a string.
 */
public class ExpressionExecutorUtil {

    public static final String SPECIAL = "SPECIAL~";
    public static final String EMPTY = "";
    private static final Logger logger = LoggerFactory.getLogger(ExpressionExecutorUtil.class);
    private static final String SCRIPT_ENGINE = "JavaScript";
    //TODO: Temporary adding here later needs to be moved to proper place
    public static final String SKIP_VALUE = "#SKIPVAL#";
    public static final String TRUE_EXP= "1=1";




    private ExpressionExecutorUtil() {
    }

    ;

    /**
     * Executes the expression by replacing the variable with the values of it.
     *
     * @param expression ex $user_level > 2
     * @return true if statement is true, else false
     * @throws ScriptException
     */
    public static boolean executeExpression(String expression) throws ScriptException {
        boolean result = false;
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(SCRIPT_ENGINE);
        //String updatedExpression = buildExpression(expression, attributes);
        try {
            expression = expression.replaceAll("=", "===");
            result = (boolean) engine.eval(expression);

        } catch (ScriptException e) {
            logger.error(e.getMessage());
            throw e;
        }
        return result;
    }

    /**
     * Builds the expression by replacing the variable with the values of it.
     *
     * @param expression ex "3>3"
     * @param attributes which is read from JWT token eg: $user.level means 'level' in attribute list
     * @return
     */


    public static String buildExpression(String expression, JsonObject attributes) {
        String[] tokens = tokenizer(expression);
        boolean isSpecial = AuthorizationExpressionParser.transformValueAndCheckIfSpecial(tokens, attributes);
        StringBuilder pseudoSql = AuthorizationExpressionParser.convertToPseudoSql(tokens);
        if ( pseudoSql == null ){
        	isSpecial= false;
        	return TRUE_EXP;
        }
        if (isSpecial) {
            pseudoSql.insert(0, SPECIAL).toString();
        }
        return pseudoSql.toString();
    }
    
    
    
    public static String[] tokenizer(String exp2) {
       
        // initializing empty String for result
        String exp = exp2.trim().replaceAll(" +", " ")
                .replaceAll(Operator.GT_EQ.getValue(), Operator.GT_EQ.getEncodedValue())
                .replaceAll(Operator.ST_EQ.getValue(), Operator.ST_EQ.getEncodedValue())
                .replaceAll(Operator.GT.getValue(), Operator.GT.getEncodedValue())
                .replaceAll(Operator.ST.getValue(), Operator.ST.getEncodedValue())
                .replaceAll(Operator.NOT_EQ.getValue(), Operator.NOT_EQ.getEncodedValue())
                .replaceAll(Operator.EQ.getValue(), Operator.EQ.getEncodedValue())
                .replaceAll(Operator.NOT.getValue(), Operator.NOT.getEncodedValue());
        String delims;
        delims = "(?=\\()|(?<=\\()|(?=\\))|(?<=\\))|(?=\\s)|(?<=\\s)|(?=,)|(?<=,)";
        delims += "|(?=" + Operator.GT.getEncodedValue() + ")|(?<=" + Operator.GT.getEncodedValue() + ")";
        delims += "|(?=" + Operator.GT_EQ.getEncodedValue() + ")|(?<=" + Operator.GT_EQ.getEncodedValue() + ")";
        delims += "|(?=" + Operator.ST.getEncodedValue() + ")|(?<=" + Operator.ST.getEncodedValue() + ")";
        delims += "|(?=" + Operator.ST_EQ.getEncodedValue() + ")|(?<=" + Operator.ST_EQ.getEncodedValue() + ")";
        delims += "|(?=" + Operator.NOT_EQ.getEncodedValue() + ")|(?<=" + Operator.NOT_EQ.getEncodedValue() + ")";
        delims += "|(?=" + Operator.EQ.getEncodedValue() + ")|(?<=" + Operator.EQ.getEncodedValue() + ")";
        delims += "|(?=" + Operator.NOT.getEncodedValue() + ")|(?<=" + Operator.NOT.getEncodedValue() + ")";

        String[] tokens = exp.split(delims);
        return tokens;
    }

}
