package com.sap.cloud.sdk.service.prov.api.security;

import java.util.Deque;
import java.util.Queue;

public class InfixSQL {

    private final String sql;
    private final Deque<InfixParam> params;

    /**
     * To be used for CDS sql
     *
     * @param sql
     */
    public InfixSQL(String sql) {
        this.sql = sql;
        this.params = null;
    }

    /**
     * To be used only for Hana  with parametrise sql
     *
     * @param sql
     * @param params
     */
    public InfixSQL(String sql, Deque<InfixParam> params) {
        this.sql = sql;
        this.params = params;
    }

    /**
     * Return Infix sql
     *
     * @return
     */
    public String getSql() {
        return sql;
    }

    /**
     * Gets InfixParams when Hanasql else return null
     *
     * @return
     */
    public Deque<InfixParam> getParams() {
        return params;
    }
}
