package com.sap.cloud.sdk.service.prov.api.security;

public class Operand {
    private final String value;

    public Operand(String value) {
        this.value = value;
    }

    public Operand transformToInfixOperand(Operator operator, Operand operand) {
        StringBuilder sb = new StringBuilder("(");
        sb.append(this.getValue());
        sb.append(" ");
        sb.append(operator.getValue());
        sb.append(" ");
        sb.append(operand.getValue());
        sb.append(")");
        return new Operand(sb.toString());

    }

    /**
     * Get new alias prefixed  operand for cds sql
     * @param alias
     * @return Operand
     */
    public Operand getOperandWithPrefixedAliasCDS(String alias,boolean isPlainSqlMapping) {
        if (alias == null || "".equals(alias)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(alias);
        if (isPlainSqlMapping){
        sb.append(this.getValue().toUpperCase());
        }
        else{
        	sb.append(this.getValue());
        }
        return new Operand(sb.toString());

    }
    
    /**
     * Get operand for cds sql with alias for sub selects
     * @param isPlainSqlMapping
     * @return Operand
     */
    public Operand getOperandWithoutAlisCDS(boolean isPlainSqlMapping) {
        StringBuilder sb = new StringBuilder();
        if (isPlainSqlMapping){
        sb.append(this.getValue().toUpperCase());
        }
        else{
        	sb.append(this.getValue());
        }
        return new Operand(sb.toString());

    }
    
    /**
     * Get new alias prefixed  operand for Hana sql
     * @param alias
     * @return Operand
     */
    public Operand getOperandWithPrefixedAlias(String alias, boolean isPlainSqlMapping) {

        if (alias == null || "".equals(alias)) {
            return null;
        }

        StringBuilder sb = new StringBuilder(alias);
        if (!isPlainSqlMapping) {
            sb.append('"');
        }
        sb.append(this.getValue());
        if (!isPlainSqlMapping) {
            sb.append('"');
        }

        return new Operand(sb.toString());

    }

    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return value;
    }
}
