package com.sap.cloud.sdk.service.prov.api.security;

import java.util.HashMap;
import java.util.Map;

public enum Operator {
    OR(1, "OR", "OR"),
    AND(2, "AND", "AND"),
    IN(3, "IN", "IN"),
    IS(3, "IS", "IS"),
    EQ(3, "=", "EQ"),
    GT(3, ">", "GT"),
    GT_EQ(3, ">=", "GTEQ"),
    ST(3, "<", "ST"),
    ST_EQ(3, "<=", "STEQ"),
    NOT_EQ(3, "!=", "NOTEQ"),
    NOT(4, "!", "NOT");
    final int precedence;
    final String value;
    final String encodedValue;

    Operator(final int precedence, final String operatorValue, final String encodingSeed) {
        this.precedence = precedence;
        value = operatorValue;
        encodedValue = "#" + encodingSeed + "#";
    }

    public static Map<String, Operator> getValueMap() {
        Map<String, Operator> operatorMap = new HashMap<>();
        for (Operator s : Operator.values()) {
            operatorMap.put(s.value, s);
        }
        return operatorMap;
    }

    public static Map<String, Operator> getEncodedValueMap() {
        Map<String, Operator> encodedOperatorMap = new HashMap<>();
        for (Operator s : Operator.values()) {
            encodedOperatorMap.put(s.encodedValue, s);
        }
        return encodedOperatorMap;
    }

    public String getValue() {
        return value;
    }

    public String getEncodedValue() {
        return encodedValue;
    }

    public int getPrecedence() {
        return precedence;
    }
}