/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.statistics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SAPStatistics {

	public static final String GENERICDATAPROVIDER = "db";
	public static final String EXTENSIONDATAPROVIDER = "ext";
	public static final String SRVIMPLEMENTATION = "impl";
	public static final String FRAMEWORK = "fw";
	public static final String TOTAL = "total";	
	public static final String STATISTICSHEADER = "sap-statistics-xsa-java-odatav4";
	public static final String STATISTICSHEADER_CXS = "sap-statistics";
	private HashMap<String,Long> timingsMap = new HashMap<String,Long>();
	
	public HashMap<String, Long> getTimingsMap() {
		return timingsMap;
	}

	public void addTimings(String type, long elapsedTime)
	{
		Long curVal = timingsMap.get(type);
		if(curVal!=null)
		{
			Long val = elapsedTime + curVal;
			timingsMap.put(type, val);
		}
		else
			timingsMap.put(type, elapsedTime);

	}
	
	public Map<String,Long> getcurrentTimings(){
		Map<String,Long> timings = Collections.unmodifiableMap(timingsMap);
		return timings;
	}
	
	public String getTimings(Long startTime)
	{
		StringBuilder timingsString = new StringBuilder(70);
		Long componentsTime = new Long(0);
		for (Map.Entry<String, Long> entry : timingsMap.entrySet()) {
		    timingsString.append(entry.getKey() + "=" + entry.getValue() + ";");
		    componentsTime = componentsTime + entry.getValue();
		}
		Long totalTime = System.currentTimeMillis() - startTime;
		Long fwTime = totalTime - componentsTime;
		timingsString.append(FRAMEWORK + "=" + fwTime + ";" + TOTAL + "=" + totalTime);		
		return timingsString.toString();
	}

	public void clear() {
		timingsMap = new HashMap<String,Long>();
	}
	

	public void addTimings(SAPStatistics statisctics) {
		Iterator<String> iterator = statisctics.getcurrentTimings().keySet().iterator();
		while (iterator.hasNext()) {
			String key = iterator.next();
			this.addTimings(key, statisctics.getcurrentTimings().get(key));
		}
	}
	
	
}
