/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.transaction;

import com.sap.cloud.sdk.service.prov.api.exception.TransactionException;

/**
 * 
 * Provides the interface to implement the Transaction Manager.
 *
 */
public interface TransactionManager {
	
	/**
	 * Method used to implement the commit transaction.
	 * @throws TransactionException
	 */
	void commitTransaction() throws TransactionException;

	/**
	 * Roll back the Transaction if something goes wrong during the transaction process.
	 */
	void rollbackTransaction() throws TransactionException;
	
	/**
	 * Method used to initialize the transaction process.
	 */
	void startTransaction() throws TransactionException;

	/**
	 * Method used to release the Data sources.
	 */
	default void cleanupTransaction() {};

}