/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.util;

import java.util.List;
import java.util.Map;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.exception.DataConversionException;

public class DataConversionUtility {

	public static Map<String, Object> convertToMap(Object data) {
		if(data instanceof Map)
			return (Map<String, Object>) data;
		else if(data instanceof EntityData)
			return ((EntityData) data).asMap();
		else if(data != null)
			return PojoUtil.getMapFromPojo(data);
		else return null;
	}
	
	public static <T> T convertToClass(Class<T> clazz, Object data) throws DataConversionException  {
		
		if(data instanceof Map)
			return (T) PojoUtil.getPojoFromMap(clazz, (Map)data);
		else if(data instanceof EntityData)
			return ((EntityData) data).as(clazz);
		else if(data != null)
			return (T) data;
		else return null;
	}
	
	public static EntityData convertToEntityData(Object data, String entityName, List<String> keyNames) {
		if(data instanceof EntityData)
			return (EntityData) data;
		else if(data instanceof Map)
			return EntityData.createFromMap((Map<String, Object>) data, keyNames, entityName);
		else if(data != null)
			return EntityData.createFrom(data, entityName);
		else return null;
	}
}
