package com.sap.cloud.sdk.service.prov.api.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Utility methods for internal use.
 */
public class GenericUtilityMethods {

	final static Logger logger = LoggerFactory.getLogger(GenericUtilityMethods.class);

	private GenericUtilityMethods() {
		throw new IllegalStateException("Should not instantiate utility class");
	}

	/**
	 * Returns a ByteArrayOutputStream for the passed input stream. This is useful
	 * if we need to make copies of an input stream if it does not support mark and
	 * reset(meaning that it can only be processed once.) This method would return a
	 * ByteArrayOutputStream from the input stream which can then be used to create
	 * as many copies of the original input stream as needed.
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static ByteArrayOutputStream getOutputStreamFromInputStream(InputStream is) throws IOException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		byte[] buffer = new byte[1024];
		int len;
		if (is != null) {
			while ((len = is.read(buffer)) > -1) {
				baos.write(buffer, 0, len);
			}
		}
		baos.flush();
		return baos;
	}

	/**
	 * Closes an input stream after checking for null.
	 * 
	 * @param is
	 */
	public static void safeClose(InputStream is) {
		if (is != null) {
			try {
				is.close();
			} catch (IOException e) {
				logger.error("Error while closing the input stream", e);
			}
		}
	}

}
