package com.sap.cloud.sdk.service.prov.api.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cloud.sdk.service.prov.api.connection.DataSourceParams;
import com.sap.cloud.sdk.service.prov.api.usercontext.UserContextParams;
import com.sap.cloud.sdk.service.prov.rt.datasource.factory.DatasourceType;

/*
 * Used to store some useful values which are independent of OData and can thus be accessed anywhere.
 * This class is not exposed outside but the framework can use it to create useful objects in a
 * non-OData context.
 * 
 *
 */
public class RequestProcessingHelper {

	private static DataSourceParams connectionProvider = null;
	private static Integer paginationSnapshotCleanUpInterval = null;
	private static Integer deltaSnapshotCleanUpInterval = null;
	private static UserContextParams userContextProvider;
	private static String odataSerializerVersion;
	private static DatasourceType datasourceProvider = DatasourceType.CDS;
	final static Logger logger = LoggerFactory.getLogger(RequestProcessingHelper.class);
	private static Boolean isAutoExposed = false;
	
	public static Boolean getIsAutoExposed() {
		return isAutoExposed;
	}

	public static void setIsAutoExposed(String isAutoExposed) {
		if(isAutoExposed.equals("true"))
			RequestProcessingHelper.isAutoExposed = true;
	}
	
	public static void setConnectionProviderClass(String connection) {
		try {
			connectionProvider = (DataSourceParams) Class.forName(connection).newInstance();
		} catch (Exception e) {
			logger.error("Error while initializing connection class " + connection, e);
		}
	}
	
	public static void setConnectionProvider(DataSourceParams dsParams) {
		connectionProvider = dsParams;
	}
	
	public static void setUserContextProvider(String ucParamsClass) {
		try {
			userContextProvider = (UserContextParams) Class.forName(ucParamsClass).newInstance();
		} catch (Exception e) {
			logger.error("Error while initializing connection class " + ucParamsClass, e);
		}
	}
	
	public static void setPaginationSnapshotCleanUpInterval(Integer minutes) {
		paginationSnapshotCleanUpInterval = minutes;
	}
	
	public static Integer getPaginationSnapshotCleanUpInterval() {
		return paginationSnapshotCleanUpInterval;
	}
	
	public static void setDeltaSnapshotCleanUpInterval(Integer days) {
		deltaSnapshotCleanUpInterval = days;
	}
	
	public static Integer getDeltaSnapshotCleanUpInterval() {
		return deltaSnapshotCleanUpInterval;
	}
	
	public static UserContextParams getUserContextProvider() {
		return userContextProvider;
	}

	public static DataSourceParams getConnectionProvider() {
		return connectionProvider;
	}
	
	public static void setDatasourceProvider(String datasourceType) {
		switch(datasourceType) {
		case "HANA":
			datasourceProvider = DatasourceType.HANA;
		    break;
		case "CDS":
			datasourceProvider = DatasourceType.CDS;
			break;
		}
	}
	
	public static DatasourceType getDatasourceProvider() {
		return datasourceProvider;
	}

	public static String getOdataSerializerVersion() {
		if(odataSerializerVersion != null && !odataSerializerVersion.isEmpty()) {
			return odataSerializerVersion;
		}else {
			return "4.01";
		}
		
	}

	public static void setOdataSerializerVersion(String odataSerializerVersion) {
		RequestProcessingHelper.odataSerializerVersion = odataSerializerVersion;
	}
	
	
	
}
