/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.util;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class ServiceSDKResourceBundle {
	private HashMap<String, ResourceBundle> allResourceBundles;
	private String resourceBundlePath = "i18n/messagebundle";
	private ResourceBundle messages;
	private static volatile ServiceSDKResourceBundle self;
	private ServiceSDKResourceBundle() {
		allResourceBundles = new HashMap<>();
	}
	
	public static ServiceSDKResourceBundle getInstance() {
		if(self == null){
			synchronized (ServiceSDKResourceBundle.class) {
				if(self == null){
					self = new ServiceSDKResourceBundle();
				}
			}
		}
		return self;
	}

	public Locale getLocale(){
		return this.messages.getLocale();
	}

	public void setLocale(Locale locale){
		this.messages = allResourceBundles.get(locale.toString().toLowerCase());
		if(this.messages == null){
			this.messages = ResourceBundle.getBundle(resourceBundlePath, locale); 
			allResourceBundles.put(locale.toString().toLowerCase(), this.messages);
		}
	}
	
	public void setLocale(String language) {
		this.messages = allResourceBundles.get(language.toLowerCase());
		if(this.messages == null){
			this.messages = ResourceBundle.getBundle(resourceBundlePath, new Locale(language)); 
			allResourceBundles.put(language.toLowerCase(), this.messages);
		}		
	}
	
	public void setLocale(String language, String country) {
		String strLocale = language.concat("_").concat(country);
		this.messages = allResourceBundles.get(strLocale.toLowerCase());
		if(this.messages == null){
			this.messages = ResourceBundle.getBundle(resourceBundlePath, new Locale(language, country)); 
			allResourceBundles.put(strLocale.toLowerCase(), this.messages);			
		}
	}
	
	public void setLocale(String language, String country, String variant) {
		String strLocale = language.concat("_").concat(country).concat("_").concat(variant);
		this.messages = allResourceBundles.get(strLocale.toLowerCase());
		if(this.messages == null){
			this.messages = ResourceBundle.getBundle(resourceBundlePath, new Locale(language, country, variant));
			allResourceBundles.put(strLocale.toLowerCase(), this.messages);			
		}
	}
	
	public String getFormattedDate(Date inputDate) {  
		DateFormat formatter=DateFormat.getDateInstance(DateFormat.DEFAULT, this.messages.getLocale());  
		String date=formatter.format(inputDate);
		return date;
	}  

	public String getFormattedDate(Date inputDate, Locale locale) {  
		DateFormat formatter=DateFormat.getDateInstance(DateFormat.DEFAULT, locale);  
		String date=formatter.format(inputDate);
		return date;
	}  
		
	public String getFormattedTime(Date inputDate){  
		DateFormat formatter=DateFormat.getTimeInstance(DateFormat.DEFAULT, this.messages.getLocale());  
		String time=formatter.format(inputDate);  
		return time;  
	}  

	public String getFormattedTime(Date inputDate, Locale locale){  
		DateFormat formatter=DateFormat.getTimeInstance(DateFormat.DEFAULT, locale);  
		String time=formatter.format(inputDate);  
		return time;  
	}  
		
	public String getFormattedNumber(double aValue) {  
		 NumberFormat formatter=NumberFormat.getNumberInstance(this.messages.getLocale());  
		 String number=formatter.format(aValue);  
		 return number; 
	}

	public String getFormattedNumber(double aValue, Locale locale) {  
		 NumberFormat formatter=NumberFormat.getNumberInstance(locale);  
		 String number=formatter.format(aValue);  
		 return number; 
	}
		
	public String getFormattedCurrency(double aValue){  
		 NumberFormat formatter=NumberFormat.getCurrencyInstance(this.messages.getLocale());  
		 String currency=formatter.format(aValue);  
		 return currency;  
	}  	

	public String getFormattedCurrency(double aValue, Locale locale){  
		 NumberFormat formatter=NumberFormat.getCurrencyInstance(locale);  
		 String currency=formatter.format(aValue);  
		 return currency;  
	}  	
		
	public String getMessage(String key)  {
		return this.messages.getString(key);
	}
	
	public String getMessage(String key, Object[] messageArguments) {
		MessageFormat formatter = new MessageFormat("");
		formatter.setLocale(this.messages.getLocale());
		formatter.applyPattern(this.messages.getString(key));
		return formatter.format(messageArguments);		
	}
	
}
