/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.model.internal;

import java.util.List;

public class CSNEntityModel {
	private String entityName = "";
	private String parentService = "";		
	private List<CSNElementModel> elements = null;
	private List<CSNAnnotationModel> annotations = null;
	private List<CSNQueryModel> queries = null;
	private List<CSNAssociationModel> associations = null;	
	private List<CSNOperationModel> functions = null;
	private List<CSNOperationModel> actions = null;	
	

	private boolean cdsPersistenceSkipAnnotationEnabled = false;
	private boolean isInsertable = false;
	private boolean isUpdatable = false;
	private boolean isDeletable = false;
	private boolean isDraftEnabled = false;
	
	public boolean isCdsPersistenceSkipAnnotationEnabled() {
		return cdsPersistenceSkipAnnotationEnabled;
	}
	public void setCdsPersistenceSkipAnnotationEnabled(boolean cdsPersistenceSkipAnnotationEnabled) {
		this.cdsPersistenceSkipAnnotationEnabled = cdsPersistenceSkipAnnotationEnabled;
	}
	
	public boolean isInsertable() {
		for(CSNAnnotationModel annotation : annotations){
			if(CSNConstants.ANNOTATION_ISINSERTABLE.equals(annotation.getName())){
				if(annotation.getValue() instanceof Boolean) {
					isInsertable = (Boolean) annotation.getValue();
					break;
				}
			}
		}
		return isInsertable;
	}
	public boolean isUpdatable() {
		for(CSNAnnotationModel annotation : annotations){
			if(CSNConstants.ANNOTATION_ISUPDATABLE.equals(annotation.getName())){
				if(annotation.getValue() instanceof Boolean) {
					isUpdatable = (Boolean) annotation.getValue();
					break;
				}
			}
		}
		return isUpdatable;
	}
	public boolean isDeletable() {
		for(CSNAnnotationModel annotation : annotations){
			if(CSNConstants.ANNOTATION_ISDELETABLE.equals(annotation.getName())){
				if(annotation.getValue() instanceof Boolean) {
					isDeletable = (Boolean) annotation.getValue();
					break;
				}
			}
		}
		return isDeletable;
	}
	
	public String getEntityName() {
		return entityName;
	}
	public void setEntityName(String entityName) {
		this.entityName = entityName;
	}
	
	public String getParentService() {
		return parentService;
	}
	public void setParentService(String parentService) {
		this.parentService = parentService;
	}
	public List<CSNElementModel> getElements() {
		return elements;
	}
	public void setElements(List<CSNElementModel> elements) {
		this.elements = elements;
	}
	public List<CSNAnnotationModel> getAnnotations() {
		return annotations;
	}
	public void setAnnotations(List<CSNAnnotationModel> annotations) {
		this.annotations = annotations;
	}
	public List<CSNQueryModel> getQueries() {
		return queries;
	}
	public void setQueries(List<CSNQueryModel> queries) {
		this.queries = queries;
	}
	public List<CSNAssociationModel> getAssociations() {
		return associations;
	}
	public void setAssociations(List<CSNAssociationModel> associations) {
		this.associations = associations;
	}
	public List<CSNOperationModel> getFunctions() {
		return functions;
	}
	public void setFunctions(List<CSNOperationModel> functions) {
		this.functions = functions;
	}
	public List<CSNOperationModel> getActions() {
		return actions;
	}
	public void setActions(List<CSNOperationModel> actions) {
		this.actions = actions;
	}
	
	public boolean isDraftEnabled() {
		return isDraftEnabled;
	}
	
	public void setDraftEnabled(boolean isDraftEnabled) {
		this.isDraftEnabled = isDraftEnabled;
	}
	
}
