/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.rt.usercontext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cloud.sdk.service.prov.api.security.AuthorizationService;
import com.sap.cloud.sdk.service.prov.api.security.JWTUtil;
import com.sap.cloud.sdk.service.prov.api.usercontext.UserContextParams;

public class UserContextXS implements UserContextParams, TenantIdProvider {

	
	final static Logger logger = LoggerFactory.getLogger(UserContextXS.class);
	 private static final String USER_NAME = "user_name";
	 private static final String SERVICE_INSTANCE_ID = "ext_attr.serviceinstanceid";
	 private static final String ZID = "zid";
	 private static final String VCAP = "vcap";
	
	@Override
	public String getUserName() {
		String userName = null;
		if (AuthorizationService.getJWTToken() != null){
			userName =  JWTUtil.getJWTAttribute(USER_NAME);
			if ("".compareTo(userName)==0){
				userName =  JWTUtil.getJWTAttribute(SERVICE_INSTANCE_ID);
				if("".compareTo(userName)==0) 
					return VCAP;
			}
			return userName;
		}			
		
		return VCAP;
	}

	@Override
	public String getUserEmail() {
		return null;
	}

	@Override
	public String getTenantId() {
		String tenantId = null;
		if (AuthorizationService.getJWTToken() != null){
			tenantId =  JWTUtil.getJWTAttribute(ZID);
		}
		return tenantId;
	}

}
