/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.ResultSet;
import com.sequoiadb.message.request.GetMoreRequest;
import com.sequoiadb.message.request.KillContextRequest;
import com.sequoiadb.message.response.SdbReply;
import com.sequoiadb.util.Helper;
import java.io.Closeable;
import org.bson.BSONObject;

public class DBCursor
implements Closeable {
    private Sequoiadb sequoiadb;
    private long contextId;
    private ResultSet resultSet;
    private boolean isClosed;
    private boolean isEOC;
    private boolean isStarted;
    private byte[] currentRaw;
    private BSONObject currentObj;

    DBCursor(Sequoiadb sequoiadb, long contextId, ResultSet resultSet) {
        this.sequoiadb = sequoiadb;
        this.contextId = contextId;
        this.resultSet = resultSet;
    }

    DBCursor(SdbReply response, Sequoiadb sequoiadb) {
        this(sequoiadb, response.getContextId(), response.getResultSet());
    }

    public boolean hasNext() throws BaseException {
        if (this.isClosed || this.isEOC) {
            return false;
        }
        this.isStarted = true;
        if (this.resultSet != null && this.resultSet.hasNext()) {
            return true;
        }
        if (this.contextId != -1L) {
            this.resultSet = this.getResultSetFromServer();
            if (this.resultSet != null && this.resultSet.hasNext()) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public boolean hasNextRaw() throws BaseException {
        return this.hasNext();
    }

    public BSONObject getNext() throws BaseException {
        if (this.hasNext()) {
            this.currentObj = this.resultSet.getNext();
            this.currentRaw = null;
            return this.currentObj;
        }
        return null;
    }

    public byte[] getNextRaw() throws BaseException {
        if (this.hasNext()) {
            this.currentRaw = this.resultSet.getNextRaw();
            this.currentObj = null;
            return this.currentRaw;
        }
        return null;
    }

    public BSONObject getCurrent() throws BaseException {
        if (!this.isStarted) {
            return this.getNext();
        }
        if (this.currentObj != null) {
            return this.currentObj;
        }
        if (this.currentRaw != null) {
            this.currentObj = Helper.decodeBSONBytes(this.currentRaw);
            return this.currentObj;
        }
        return null;
    }

    private ResultSet getResultSetFromServer() {
        GetMoreRequest request = new GetMoreRequest(this.contextId, -1);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        int flag = response.getFlag();
        if (flag != 0) {
            this.contextId = -1L;
            if (flag == SDBError.SDB_DMS_EOC.getErrorCode()) {
                this.isEOC = true;
                return null;
            }
            this.sequoiadb.throwIfError(response);
        }
        return response.getResultSet();
    }

    @Override
    public void close() throws BaseException {
        if (!this.isClosed) {
            this.killContext();
            this.isClosed = true;
        }
    }

    private void killContext() {
        if (this.contextId == -1L) {
            return;
        }
        long[] contextIds = new long[]{this.contextId};
        KillContextRequest request = new KillContextRequest(contextIds);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response);
        this.contextId = -1L;
    }
}

