/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.DBCollection;
import com.sequoiadb.base.DBLob;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.ResultSet;
import com.sequoiadb.message.request.LobCloseRequest;
import com.sequoiadb.message.request.LobLockRequest;
import com.sequoiadb.message.request.LobOpenRequest;
import com.sequoiadb.message.request.LobReadRequest;
import com.sequoiadb.message.request.LobRuntimeDetailRequest;
import com.sequoiadb.message.request.LobWriteRequest;
import com.sequoiadb.message.response.LobOpenResponse;
import com.sequoiadb.message.response.LobReadResponse;
import com.sequoiadb.message.response.SdbReply;
import com.sequoiadb.util.Helper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.ObjectId;

class DBLobImpl
implements DBLob {
    static final String FIELD_NAME_LOB_OPEN_MODE = "Mode";
    static final String FIELD_NAME_LOB_OID = "Oid";
    static final String FIELD_NAME_LOB_SIZE = "Size";
    static final String FIELD_NAME_LOB_CREATE_TIME = "CreateTime";
    static final String FIELD_NAME_LOB_MODIFICATION_TIME = "ModificationTime";
    static final String FIELD_NAME_LOB_PAGESIZE = "LobPageSize";
    static final String FIELD_NAME_LOB_LENGTH = "Length";
    static final int SDB_LOB_CREATEONLY = 1;
    private static final int SDB_LOB_MAX_WRITE_DATA_LENGTH = 0x200000;
    private static final int SDB_LOB_WRITE_DATA_LENGTH = 524288;
    private static final int SDB_LOB_READ_DATA_LENGTH = 65536;
    private static final int SDB_LOB_ALIGNED_LEN = 524288;
    private static final int FLG_LOBOPEN_WITH_RETURNDATA = 2;
    private Sequoiadb _sdb;
    private DBCollection _cl;
    private ObjectId _id;
    private int _mode;
    private int _pageSize;
    private long _lobSize;
    private long _createTime;
    private long _modificationTime;
    private long _currentOffset = 0L;
    private long _cachedOffset = -1L;
    private ByteBuffer _cachedDataBuff = null;
    private ByteBuffer _receivedBuff = null;
    private boolean _isOpened = false;
    private boolean _isOldVersionLobServer = false;
    private long _contextID;
    private byte[] _tmpWriteBuf = null;
    private byte[] _tmpReadBuf = null;

    DBLobImpl(DBCollection cl) throws BaseException {
        if (cl == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "cl is null");
        }
        this._cl = cl;
        this._sdb = cl.getSequoiadb();
    }

    public static boolean isReadOnlyMode(int mode) {
        return mode == 4 || mode == 64;
    }

    public static boolean isReadWriteMode(int mode) {
        return mode == 72;
    }

    public static boolean hasWriteMode(int mode) {
        return mode == 8 || DBLobImpl.isReadWriteMode(mode);
    }

    public void open(ObjectId id) {
        this.open(id, 4);
    }

    public void open(ObjectId id, int mode) throws BaseException {
        if (this._isOpened) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "lob have opened: id = " + this._id);
        }
        if (mode != 1 && !DBLobImpl.hasWriteMode(mode) && !DBLobImpl.isReadOnlyMode(mode)) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "mode is unsupported: " + mode);
        }
        if (mode != 1 && id == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "id must be specify in mode:" + mode);
        }
        this._mode = mode;
        this._currentOffset = 0L;
        this._id = id;
        if (this._mode != 1) {
            this._open();
            this._isOpened = true;
            return;
        }
        if (this._sdb.getIsOldVersionLobServer()) {
            if (this._id == null) {
                this._id = ObjectId.get();
            }
            this._open();
            this._isOpened = true;
            return;
        }
        try {
            this._isOldVersionLobServer = false;
            this._open();
            this._isOpened = true;
            return;
        }
        catch (BaseException e) {
            if (!this._isOldVersionLobServer) {
                throw e;
            }
            this._id = ObjectId.get();
            this._open();
            this._sdb.setIsOldVersionLobServer(true);
            this._isOpened = true;
            return;
        }
    }

    private void _open() throws BaseException {
        BasicBSONObject openLob = new BasicBSONObject();
        openLob.put("Collection", (Object)this._cl.getFullName());
        if (this._id != null) {
            openLob.put(FIELD_NAME_LOB_OID, (Object)this._id);
        }
        openLob.put(FIELD_NAME_LOB_OPEN_MODE, (Object)this._mode);
        int flags = this._mode == 4 ? 2 : 0;
        LobOpenRequest request = new LobOpenRequest(openLob, flags);
        LobOpenResponse response = this._sdb.requestAndResponse(request, LobOpenResponse.class, this._receivedBuff);
        if (response.getFlag() == SDBError.SDB_INVALIDARG.getErrorCode() && this._id == null && this._mode == 1) {
            this._isOldVersionLobServer = true;
        }
        this._sdb.throwIfError(response, openLob);
        BSONObject obj = response.getMetaInfo();
        if (this._id == null && obj.containsField(FIELD_NAME_LOB_OID) && this._mode == 1) {
            this._id = (ObjectId)obj.get(FIELD_NAME_LOB_OID);
        }
        this._lobSize = (Long)obj.get(FIELD_NAME_LOB_SIZE);
        this._createTime = (Long)obj.get(FIELD_NAME_LOB_CREATE_TIME);
        this._modificationTime = obj.containsField(FIELD_NAME_LOB_MODIFICATION_TIME) ? (Long)obj.get(FIELD_NAME_LOB_MODIFICATION_TIME) : this._createTime;
        this._pageSize = (Integer)obj.get(FIELD_NAME_LOB_PAGESIZE);
        this._cachedDataBuff = this._receivedBuff = response.getData();
        if (this._cachedDataBuff != null) {
            this._cachedOffset = this._currentOffset = 0L;
        }
        this._contextID = response.getContextId();
    }

    @Override
    public ObjectId getID() {
        return this._id;
    }

    @Override
    public long getSize() {
        return this._lobSize;
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public long getModificationTime() {
        return this._modificationTime;
    }

    @Override
    public void close() throws BaseException {
        ResultSet resultSet;
        BSONObject obj;
        if (!this._isOpened) {
            return;
        }
        this._sdb.cleanRequestBuff();
        this._receivedBuff = null;
        this._cachedDataBuff = null;
        this._tmpReadBuf = null;
        this._tmpWriteBuf = null;
        LobCloseRequest request = new LobCloseRequest(this._contextID);
        SdbReply response = this._sdb.requestAndResponse(request);
        this._sdb.throwIfError(response);
        this._isOpened = false;
        if (response.getReturnedNum() > 0 && (obj = (resultSet = response.getResultSet()).getNext()) != null && obj.containsField(FIELD_NAME_LOB_MODIFICATION_TIME)) {
            this._modificationTime = (Long)obj.get(FIELD_NAME_LOB_MODIFICATION_TIME);
        }
    }

    @Override
    public void write(InputStream in) throws BaseException {
        if (!this._isOpened) {
            throw new BaseException(SDBError.SDB_LOB_NOT_OPEN, "lob is not open");
        }
        if (in == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "input is null");
        }
        int readNum = 0;
        if (this._tmpWriteBuf == null) {
            this._tmpWriteBuf = new byte[524288];
        }
        try {
            while (-1 < (readNum = in.read(this._tmpWriteBuf))) {
                this.write(this._tmpWriteBuf, 0, readNum);
            }
        }
        catch (IOException e) {
            throw new BaseException(SDBError.SDB_SYS, (Throwable)e);
        }
    }

    @Override
    public void write(byte[] b) throws BaseException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws BaseException {
        if (!this._isOpened) {
            throw new BaseException(SDBError.SDB_LOB_NOT_OPEN, "lob is not open");
        }
        if (b == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "input is null");
        }
        if (len < 0 || len > b.length) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "invalid len");
        }
        if (off < 0 || off > b.length) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "invalid off");
        }
        if (off + len > b.length) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "off + len is great than b.length");
        }
        if (1 != this._mode && !DBLobImpl.hasWriteMode(this._mode)) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "invalid mode for writing");
        }
        if (DBLobImpl.isReadWriteMode(this._mode)) {
            this._cachedOffset = -1L;
            this._cachedDataBuff = null;
        }
        int offset = off;
        int leftLen = len;
        int writeLen = 0;
        while (leftLen > 0) {
            writeLen = leftLen < 0x200000 ? leftLen : 0x200000;
            this._write(b, offset, writeLen);
            leftLen -= writeLen;
            offset += writeLen;
        }
    }

    @Override
    public void read(OutputStream out) throws BaseException {
        if (!this._isOpened) {
            throw new BaseException(SDBError.SDB_LOB_NOT_OPEN, "lob is not open");
        }
        if (out == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "output stream is null");
        }
        int readNum = 0;
        if (this._tmpReadBuf == null) {
            this._tmpReadBuf = new byte[65536];
        }
        while (-1 < (readNum = this.read(this._tmpReadBuf, 0, this._tmpReadBuf.length))) {
            try {
                out.write(this._tmpReadBuf, 0, readNum);
            }
            catch (IOException e) {
                throw new BaseException(SDBError.SDB_SYS, (Throwable)e);
            }
        }
    }

    @Override
    public int read(byte[] b) throws BaseException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws BaseException {
        if (!this._isOpened) {
            throw new BaseException(SDBError.SDB_LOB_NOT_OPEN, "lob is not open");
        }
        if (b == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "b is null");
        }
        if (len < 0 || len > b.length) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "invalid len");
        }
        if (off < 0 || off > b.length) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "invalid off");
        }
        if (off + len > b.length) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "off + len is great than b.length");
        }
        if (b.length == 0) {
            return 0;
        }
        if (!DBLobImpl.isReadOnlyMode(this._mode) && !DBLobImpl.isReadWriteMode(this._mode)) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "invalid mode for reading");
        }
        return this._read(b, off, len);
    }

    @Override
    public void seek(long size, int seekType) throws BaseException {
        if (!this._isOpened) {
            throw new BaseException(SDBError.SDB_LOB_NOT_OPEN, "lob is not open");
        }
        if (!DBLobImpl.hasWriteMode(this._mode) && !DBLobImpl.isReadOnlyMode(this._mode) && this._mode != 1) {
            throw new BaseException(SDBError.SDB_OPTION_NOT_SUPPORT, "seek() is not supported in mode=" + this._mode);
        }
        if (0 == seekType) {
            if (size < 0L || size >= this._lobSize && this._mode == 4) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "out of bound, lobSize=" + this._lobSize);
            }
            this._currentOffset = size;
        } else if (1 == seekType) {
            if (this._currentOffset + size >= this._lobSize && this._mode == 4 || this._currentOffset + size < 0L) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "out of bound, _currentOffset=" + this._currentOffset + ", lobSize=" + this._lobSize);
            }
            this._currentOffset += size;
        } else if (2 == seekType) {
            if (size < 0L || size > this._lobSize && this._mode == 4) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "out of bound, lobSize=" + this._lobSize);
            }
            this._currentOffset = this._lobSize - size;
        } else {
            throw new BaseException(SDBError.SDB_INVALIDARG, "unreconigzed seekType: " + seekType);
        }
    }

    @Override
    public void lock(long offset, long length) throws BaseException {
        if (!this._isOpened) {
            throw new BaseException(SDBError.SDB_LOB_NOT_OPEN, "lob is not open");
        }
        if (offset < 0L || length < -1L || length == 0L) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "out of bound, offset=" + offset + ", length=" + length);
        }
        if (!DBLobImpl.hasWriteMode(this._mode) && this._mode != 64) {
            return;
        }
        LobLockRequest request = new LobLockRequest(this._contextID, offset, length);
        SdbReply response = this._sdb.requestAndResponse(request);
        this._sdb.throwIfError(response);
    }

    @Override
    public void lockAndSeek(long offset, long length) throws BaseException {
        this.lock(offset, length);
        this.seek(offset, 0);
    }

    @Override
    public boolean isEof() {
        return this._currentOffset >= this._lobSize;
    }

    private int _reviseReadLen(int needLen) {
        int mod = (int)(this._currentOffset & (long)(this._pageSize - 1));
        int alignedLen = Helper.alignedSize(needLen, 524288);
        if (alignedLen < needLen) {
            alignedLen = 524288;
        }
        if ((alignedLen -= mod) < 524288) {
            alignedLen += 524288;
        }
        return alignedLen;
    }

    private boolean _hasDataCached() {
        int remaining = this._cachedDataBuff != null ? this._cachedDataBuff.remaining() : 0;
        return this._cachedDataBuff != null && 0 < remaining && 0L <= this._cachedOffset && this._cachedOffset <= this._currentOffset && this._currentOffset < this._cachedOffset + (long)remaining;
    }

    private int _readInCache(byte[] buf, int off, int needRead) {
        if (needRead > buf.length - off) {
            throw new BaseException(SDBError.SDB_SYS, "buf size is to small");
        }
        int readInCache = (int)(this._cachedOffset + (long)this._cachedDataBuff.remaining() - this._currentOffset);
        int n = readInCache = readInCache <= needRead ? readInCache : needRead;
        if (this._currentOffset > this._cachedOffset) {
            int currentPos = this._cachedDataBuff.position();
            int newPos = currentPos + (int)(this._currentOffset - this._cachedOffset);
            this._cachedDataBuff.position(newPos);
        }
        this._cachedDataBuff.get(buf, off, readInCache);
        if (this._cachedDataBuff.remaining() == 0) {
            this._cachedDataBuff = null;
        } else {
            this._cachedOffset = this._currentOffset + (long)readInCache;
        }
        return readInCache;
    }

    private int _onceRead(byte[] buf, int off, int len) {
        long offsetInEngine;
        int needRead = len;
        int totalRead = 0;
        int onceRead = 0;
        int alignedLen = 0;
        if (this._hasDataCached()) {
            onceRead = this._readInCache(buf, off, needRead);
            needRead -= onceRead;
            this._currentOffset += (long)onceRead;
            return totalRead += onceRead;
        }
        this._cachedOffset = -1L;
        this._cachedDataBuff = null;
        alignedLen = this._reviseReadLen(needRead);
        LobReadRequest request = new LobReadRequest(this._contextID, alignedLen, this._currentOffset);
        LobReadResponse response = this._sdb.requestAndResponse(request, LobReadResponse.class, this._receivedBuff);
        int rc = response.getFlag();
        if (rc == SDBError.SDB_EOF.getErrorCode()) {
            return -1;
        }
        if (rc != 0) {
            this._sdb.throwIfError(response);
        }
        if (this._currentOffset != (offsetInEngine = response.getOffset())) {
            throw new BaseException(SDBError.SDB_SYS, "local read offset(" + this._currentOffset + ") is not equal with what we expect(" + offsetInEngine + ")");
        }
        int retLobLen = response.getLobLen();
        this._cachedDataBuff = this._receivedBuff = response.getData();
        if (this._cachedDataBuff == null) {
            throw new BaseException(SDBError.SDB_SYS, "The returned data is empty");
        }
        int remainLen = this._cachedDataBuff.remaining();
        if (remainLen != retLobLen) {
            throw new BaseException(SDBError.SDB_SYS, "the remaining in buffer(" + remainLen + ") is not equal with what we expect(" + retLobLen + ")");
        }
        if (needRead < retLobLen) {
            this._cachedDataBuff.get(buf, off, needRead);
            totalRead += needRead;
            this._currentOffset += (long)needRead;
            this._cachedOffset = this._currentOffset;
        } else {
            this._cachedDataBuff.get(buf, off, retLobLen);
            totalRead += retLobLen;
            this._currentOffset += (long)retLobLen;
            this._cachedOffset = -1L;
            this._cachedDataBuff = null;
        }
        return totalRead;
    }

    private int _read(byte[] b, int off, int len) {
        int offset = off;
        int needRead = len;
        int onceRead = 0;
        int totalRead = 0;
        if (this._currentOffset == this._lobSize) {
            return -1;
        }
        while (needRead > 0 && this._currentOffset < this._lobSize) {
            onceRead = this._onceRead(b, offset, needRead);
            if (onceRead == -1) {
                if (totalRead != 0) break;
                totalRead = -1;
                break;
            }
            offset += onceRead;
            needRead -= onceRead;
            totalRead += onceRead;
            onceRead = 0;
        }
        return totalRead;
    }

    private void _write(byte[] input, int off, int len) throws BaseException {
        if (len == 0) {
            return;
        }
        LobWriteRequest request = new LobWriteRequest(this._contextID, input, off, len, this._currentOffset);
        SdbReply response = this._sdb.requestAndResponse(request);
        this._sdb.throwIfError(response);
        this._currentOffset += (long)len;
        this._lobSize = Math.max(this._lobSize, this._currentOffset);
    }

    @Override
    public BSONObject getRunTimeDetail() throws BaseException {
        LobRuntimeDetailRequest request = new LobRuntimeDetailRequest(this._contextID);
        SdbReply response = this._sdb.requestAndResponse(request);
        this._sdb.throwIfError(response);
        ResultSet r = response.getResultSet();
        if (!r.hasNext()) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "Response must have obj");
        }
        BSONObject o = r.getNext();
        return o;
    }
}

