/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.ResultSet;
import com.sequoiadb.message.request.AdminRequest;
import com.sequoiadb.message.request.SequenceFetchRequest;
import com.sequoiadb.message.response.SdbReply;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class DBSequence {
    private String name;
    private Sequoiadb sdb;

    DBSequence(String name, Sequoiadb sdb) {
        this.name = name;
        this.sdb = sdb;
    }

    public String getName() {
        return this.name;
    }

    public BSONObject fetch(int fetchNum) {
        if (fetchNum < 1) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "fetchNum cannot be less than 1");
        }
        BasicBSONObject matcher = new BasicBSONObject();
        matcher.put("Name", (Object)this.name);
        matcher.put("FetchNum", (Object)fetchNum);
        SequenceFetchRequest request = new SequenceFetchRequest(matcher);
        SdbReply response = this.sdb.requestAndResponse(request);
        this.sdb.throwIfError(response);
        ResultSet resultSet = response.getResultSet();
        BSONObject result = null;
        if (resultSet != null) {
            result = resultSet.getNext();
        }
        return result;
    }

    public long getCurrentValue() {
        Object currentValue;
        BSONObject obj;
        BasicBSONObject matcher = new BasicBSONObject("Name", this.name);
        AdminRequest request = new AdminRequest("$get sequence current value", matcher);
        SdbReply response = this.sdb.requestAndResponse(request);
        this.sdb.throwIfError(response);
        ResultSet resultSet = response.getResultSet();
        if (resultSet != null && (obj = resultSet.getNext()) != null && (currentValue = obj.get("CurrentValue")) != null) {
            return (Long)currentValue;
        }
        throw new BaseException(SDBError.SDB_NET_BROKEN_MSG, "Failed to get CurrentValue from response message");
    }

    public long getNextValue() {
        Object value;
        BSONObject obj = this.fetch(1);
        String targetKey = "NextValue";
        if (obj != null && (value = obj.get(targetKey)) != null) {
            return (Long)value;
        }
        throw new BaseException(SDBError.SDB_NET_BROKEN_MSG, "Failed to get " + targetKey + " from response message");
    }

    public void restart(long startValue) {
        BasicBSONObject obj = new BasicBSONObject("StartValue", startValue);
        this._alterInternal("restart", obj);
    }

    public void setAttributes(BSONObject options) {
        this._alterInternal("set attributes", options);
    }

    public void setCurrentValue(long value) {
        BasicBSONObject obj = new BasicBSONObject("ExpectValue", value);
        this._alterInternal("set current value", obj);
    }

    private void _alterInternal(String actionName, BSONObject options) {
        if (options != null && options.get("Name") != null) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        BasicBSONObject obj = new BasicBSONObject();
        BasicBSONObject subObj = new BasicBSONObject();
        subObj.put("Name", (Object)this.name);
        subObj.putAll(options);
        obj.put("Action", (Object)actionName);
        obj.put("Options", (Object)subObj);
        AdminRequest request = new AdminRequest("$alter sequence", obj);
        SdbReply response = this.sdb.requestAndResponse(request);
        this.sdb.throwIfError(response);
    }
}

