/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.AdminRequest;
import com.sequoiadb.message.response.SdbReply;
import com.sequoiadb.util.Helper;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class DataSource {
    private String name;
    private Sequoiadb sequoiadb;

    DataSource(Sequoiadb sequoiadb, String name) {
        this.name = name;
        this.sequoiadb = sequoiadb;
    }

    public String getName() {
        return this.name;
    }

    public void alterDataSource(BSONObject option) throws BaseException {
        if (option == null || option.isEmpty()) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "option can not be null or empty");
        }
        String newDSName = null;
        BasicBSONObject obj = new BasicBSONObject();
        for (String key : option.keySet()) {
            if (key.equals("Name")) {
                newDSName = (String)option.get(key);
            }
            if (key.equals("Password")) {
                String pwd = Helper.md5((String)option.get(key));
                obj.put(key, (Object)pwd);
                continue;
            }
            obj.put(key, option.get(key));
        }
        BasicBSONObject matcher = new BasicBSONObject();
        matcher.put("Name", (Object)this.name);
        matcher.put("Options", (Object)obj);
        AdminRequest request = new AdminRequest("$alter datasource", matcher);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response);
        if (newDSName != null) {
            this.name = newDSName;
        }
    }
}

