/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.DBCursor;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.AdminRequest;
import com.sequoiadb.message.response.SdbReply;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;

public class Domain {
    private String name;
    private Sequoiadb sequoiadb;

    public String getName() {
        return this.name;
    }

    public Sequoiadb getSequoiadb() {
        return this.sequoiadb;
    }

    Domain(Sequoiadb sequoiadb, String name) {
        this.name = name;
        this.sequoiadb = sequoiadb;
    }

    private void alterInternal(String taskName, BSONObject options, boolean allowNullArgs) throws BaseException {
        if (null == options && !allowNullArgs) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "options is null");
        }
        BasicBSONObject argumentObj = new BasicBSONObject();
        argumentObj.put("Name", (Object)taskName);
        argumentObj.put("Args", (Object)options);
        BasicBSONObject alterObject = new BasicBSONObject();
        alterObject.put("Alter", (Object)argumentObj);
        this.alterDomain(alterObject);
    }

    public void alterDomain(BSONObject options) throws BaseException {
        if (null == options) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "options is null");
        }
        BasicBSONObject newObj = new BasicBSONObject();
        if (!options.containsField("Alter")) {
            newObj.put("Name", (Object)this.name);
            newObj.put("Options", (Object)options);
        } else {
            Object tmpAlter = options.get("Alter");
            if (!(tmpAlter instanceof BasicBSONObject) && !(tmpAlter instanceof BasicBSONList)) {
                throw new BaseException(SDBError.SDB_INVALIDARG, options.toString());
            }
            newObj.put("Alter", tmpAlter);
            newObj.put("AlterType", (Object)"domain");
            newObj.put("Version", (Object)1);
            newObj.put("Name", (Object)this.name);
            if (options.containsField("Options")) {
                Object tmpOptions = options.get("Options");
                if (tmpOptions instanceof BasicBSONObject) {
                    newObj.put("Options", tmpOptions);
                } else {
                    throw new BaseException(SDBError.SDB_INVALIDARG, options.toString());
                }
            }
        }
        AdminRequest request = new AdminRequest("$alter domain", newObj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response);
    }

    public void addGroups(BSONObject options) throws BaseException {
        this.alterInternal("add groups", options, false);
    }

    public void setGroups(BSONObject options) throws BaseException {
        this.alterInternal("set groups", options, false);
    }

    public void removeGroups(BSONObject options) throws BaseException {
        this.alterInternal("remove groups", options, false);
    }

    public void setAttributes(BSONObject options) throws BaseException {
        this.alterInternal("set attributes", options, false);
    }

    public DBCursor listCSInDomain() throws BaseException {
        return this.listCSCL(130);
    }

    public DBCursor listCLInDomain() throws BaseException {
        return this.listCSCL(129);
    }

    private DBCursor listCSCL(int type) throws BaseException {
        BasicBSONObject matcher = new BasicBSONObject();
        BasicBSONObject selector = new BasicBSONObject();
        matcher.put("Domain", (Object)this.name);
        selector.put("Name", (Object)null);
        DBCursor cursor = this.sequoiadb.getList(type, matcher, selector, null);
        return cursor;
    }
}

