/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.datasource;

import com.sequoiadb.datasource.ConnItem;
import com.sequoiadb.datasource.IConnectStrategy;
import com.sequoiadb.datasource.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class AbstractStrategy
implements IConnectStrategy {
    protected ArrayDeque<ConnItem> _activeConnItemDeque = new ArrayDeque();
    protected ArrayDeque<ConnItem> _newlyCreatedConnItemDeque = new ArrayDeque();
    protected ArrayList<String> _addrs = new ArrayList();
    protected Lock _opLock = new ReentrantLock();
    protected Lock _addrLock = new ReentrantLock();

    AbstractStrategy() {
    }

    @Override
    public void init(List<String> addressList, List<Pair> _idleConnPairs, List<Pair> _usedConnPairs) {
        for (String addr : addressList) {
            this._addAddress(addr);
        }
        if (_idleConnPairs != null) {
            for (Pair pair : _idleConnPairs) {
                String addr = pair.first().getAddr();
                this._addConnItem(pair.first());
                this._addAddress(addr);
            }
        }
    }

    @Override
    public abstract String getAddress();

    @Override
    public ConnItem pollConnItemForGetting() {
        this._opLock.lock();
        try {
            ConnItem connItem = this._activeConnItemDeque.pollFirst();
            if (connItem == null) {
                connItem = this._newlyCreatedConnItemDeque.pollFirst();
            }
            ConnItem connItem2 = connItem;
            return connItem2;
        }
        finally {
            this._opLock.unlock();
        }
    }

    @Override
    public ConnItem pollConnItemForDeleting() {
        this._opLock.lock();
        try {
            ConnItem connItem = this._newlyCreatedConnItemDeque.pollFirst();
            if (connItem == null) {
                connItem = this._activeConnItemDeque.pollLast();
            }
            ConnItem connItem2 = connItem;
            return connItem2;
        }
        finally {
            this._opLock.unlock();
        }
    }

    @Override
    public ConnItem peekConnItemForDeleting() {
        this._opLock.lock();
        try {
            ConnItem connItem = this._newlyCreatedConnItemDeque.peekFirst();
            if (connItem == null) {
                connItem = this._activeConnItemDeque.peekLast();
            }
            ConnItem connItem2 = connItem;
            return connItem2;
        }
        finally {
            this._opLock.unlock();
        }
    }

    @Override
    public void removeConnItemAfterCleaning(ConnItem connItem) {
    }

    @Override
    public void updateUsedConnItemCount(ConnItem connItem, int change) {
    }

    @Override
    public void addAddress(String addr) {
        this._addAddress(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConnItem> removeAddress(String addr) {
        ArrayList<ConnItem> returnList = new ArrayList<ConnItem>();
        this._addrLock.lock();
        try {
            if (this._addrs.contains(addr)) {
                this._addrs.remove(addr);
            }
        }
        finally {
            this._addrLock.unlock();
        }
        this._opLock.lock();
        try {
            ConnItem connItem;
            Iterator<ConnItem> iterator = this._activeConnItemDeque.iterator();
            while (iterator.hasNext()) {
                connItem = iterator.next();
                if (!addr.equals(connItem.getAddr())) continue;
                returnList.add(connItem);
                iterator.remove();
            }
            iterator = this._newlyCreatedConnItemDeque.iterator();
            while (iterator.hasNext()) {
                connItem = iterator.next();
                if (!addr.equals(connItem.getAddr())) continue;
                returnList.add(connItem);
                iterator.remove();
            }
        }
        finally {
            this._opLock.unlock();
        }
        return returnList;
    }

    @Override
    public void addConnItemAfterCreating(ConnItem connItem) {
        this._addConnItem(connItem);
    }

    @Override
    public void addConnItemAfterReleasing(ConnItem connItem) {
        this._releaseConnItem(connItem);
    }

    private void _addConnItem(ConnItem connItem) {
        this._opLock.lock();
        try {
            this._newlyCreatedConnItemDeque.addLast(connItem);
        }
        finally {
            this._opLock.unlock();
        }
    }

    private void _releaseConnItem(ConnItem connItem) {
        this._opLock.lock();
        try {
            this._activeConnItemDeque.addFirst(connItem);
        }
        finally {
            this._opLock.unlock();
        }
    }

    private void _addAddress(String addr) {
        this._addrLock.lock();
        try {
            if (!this._addrs.contains(addr)) {
                this._addrs.add(addr);
            }
        }
        finally {
            this._addrLock.unlock();
        }
    }
}

