/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.datasource;

import com.sequoiadb.datasource.ConnItem;
import com.sequoiadb.datasource.CountInfo;
import com.sequoiadb.datasource.IConnectStrategy;
import com.sequoiadb.datasource.Operation;
import com.sequoiadb.datasource.Pair;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;

class ConcreteBalanceStrategy
implements IConnectStrategy {
    private HashMap<String, ArrayDeque<ConnItem>> _idleConnItemMap = new HashMap();
    private HashMap<String, CountInfo> _countInfoMap = new HashMap();
    private TreeSet<CountInfo> _countInfoSet = new TreeSet();
    private static CountInfo _dumpCountInfo = new CountInfo("", 0, false);

    ConcreteBalanceStrategy() {
    }

    @Override
    public synchronized void init(List<String> addressList, List<Pair> _idleConnPairs, List<Pair> _usedConnPairs) {
        String addr;
        ConnItem item;
        for (String addr2 : addressList) {
            if (this._idleConnItemMap.containsKey(addr2)) continue;
            this._idleConnItemMap.put(addr2, new ArrayDeque());
            CountInfo obj = new CountInfo(addr2, 0, false);
            this._countInfoMap.put(addr2, obj);
            this._countInfoSet.add(obj);
        }
        Iterator<Pair> itr2 = null;
        if (_idleConnPairs != null) {
            for (Pair pair : _idleConnPairs) {
                CountInfo info;
                ArrayDeque<Object> deque;
                item = pair.first();
                addr = item.getAddr();
                if (!this._idleConnItemMap.containsKey(addr)) {
                    deque = new ArrayDeque<ConnItem>();
                    deque.add(item);
                    this._idleConnItemMap.put(addr, deque);
                    info = new CountInfo(addr, 0, true);
                    this._countInfoMap.put(addr, info);
                    this._countInfoSet.add(info);
                    continue;
                }
                deque = this._idleConnItemMap.get(addr);
                deque.add(item);
                info = this._countInfoMap.get(addr);
                if (info.getHasLeftIdleConn()) continue;
                this._countInfoSet.remove(info);
                info.setHasLeftIdleConn(true);
                this._countInfoSet.add(info);
            }
        }
        if (_usedConnPairs != null) {
            for (Pair pair : _usedConnPairs) {
                item = pair.first();
                addr = item.getAddr();
                if (!this._idleConnItemMap.containsKey(addr)) continue;
                CountInfo info = this._countInfoMap.get(addr);
                this._countInfoSet.remove(info);
                info.changeCount(1);
                this._countInfoSet.add(info);
            }
        }
    }

    @Override
    public synchronized ConnItem pollConnItemForGetting() {
        return this._pollConnItem(Operation.GET_CONN);
    }

    @Override
    public synchronized ConnItem pollConnItemForDeleting() {
        return this._pollConnItem(Operation.DEL_CONN);
    }

    @Override
    public synchronized ConnItem peekConnItemForDeleting() {
        ConnItem connItem = null;
        while (true) {
            CountInfo countInfo = null;
            String addr = null;
            countInfo = this._countInfoSet.lower(_dumpCountInfo);
            if (countInfo == null || !countInfo.getHasLeftIdleConn()) {
                return null;
            }
            addr = countInfo.getAddress();
            ArrayDeque<ConnItem> deque = this._idleConnItemMap.get(addr);
            if (deque == null) {
                throw new BaseException(SDBError.SDB_SYS, "Invalid state in strategy");
            }
            connItem = deque.peekLast();
            if (connItem != null) break;
            countInfo = this._countInfoMap.get(addr);
            this._countInfoSet.remove(countInfo);
            countInfo.setHasLeftIdleConn(false);
            this._countInfoSet.add(countInfo);
        }
        return connItem;
    }

    private ConnItem _pollConnItem(Operation operation) {
        ConnItem connItem = null;
        while (true) {
            CountInfo countInfo = null;
            String addr = null;
            if (operation == Operation.GET_CONN) {
                try {
                    countInfo = this._countInfoSet.first();
                }
                catch (NoSuchElementException e) {
                    countInfo = null;
                }
            } else {
                countInfo = this._countInfoSet.lower(_dumpCountInfo);
            }
            if (countInfo == null || !countInfo.getHasLeftIdleConn()) {
                return null;
            }
            addr = countInfo.getAddress();
            ArrayDeque<ConnItem> deque = this._idleConnItemMap.get(addr);
            if (deque != null) {
                connItem = operation == Operation.GET_CONN ? deque.pollFirst() : deque.pollLast();
            } else {
                throw new BaseException(SDBError.SDB_SYS, "Invalid state in strategy");
            }
            if (connItem != null) break;
            countInfo = this._countInfoMap.get(addr);
            this._countInfoSet.remove(countInfo);
            countInfo.setHasLeftIdleConn(false);
            this._countInfoSet.add(countInfo);
        }
        return connItem;
    }

    @Override
    public synchronized void addConnItemAfterCreating(ConnItem connItem) {
        ArrayDeque<ConnItem> deque;
        CountInfo countInfo;
        String addr = connItem.getAddr();
        if (!this._idleConnItemMap.containsKey(addr)) {
            this._restoreIdleConnItemInfo(addr);
        }
        if ((countInfo = this._countInfoMap.get(addr)) == null) {
            throw new BaseException(SDBError.SDB_SYS, "the pool has no information about address: " + addr);
        }
        if (!countInfo.getHasLeftIdleConn()) {
            this._countInfoSet.remove(countInfo);
            countInfo.setHasLeftIdleConn(true);
            this._countInfoSet.add(countInfo);
        }
        if ((deque = this._idleConnItemMap.get(addr)) == null) {
            throw new BaseException(SDBError.SDB_SYS, "the pool has no information about address: " + addr);
        }
        deque.addLast(connItem);
    }

    @Override
    public synchronized void addConnItemAfterReleasing(ConnItem connItem) {
        ArrayDeque<ConnItem> deque;
        CountInfo countInfo;
        String addr = connItem.getAddr();
        if (!this._idleConnItemMap.containsKey(addr)) {
            this._restoreIdleConnItemInfo(addr);
        }
        if ((countInfo = this._countInfoMap.get(addr)) == null) {
            throw new BaseException(SDBError.SDB_SYS, "the pool has no information about address: " + addr);
        }
        if (!countInfo.getHasLeftIdleConn()) {
            this._countInfoSet.remove(countInfo);
            countInfo.setHasLeftIdleConn(true);
            this._countInfoSet.add(countInfo);
        }
        if ((deque = this._idleConnItemMap.get(addr)) == null) {
            throw new BaseException(SDBError.SDB_SYS, "the pool has no information about address: " + addr);
        }
        deque.addFirst(connItem);
    }

    @Override
    public synchronized void removeConnItemAfterCleaning(ConnItem connItem) {
        ArrayDeque<ConnItem> deque;
        String addr = connItem.getAddr();
        if (!this._idleConnItemMap.containsKey(addr)) {
            this._restoreIdleConnItemInfo(addr);
        }
        if ((deque = this._idleConnItemMap.get(addr)) == null) {
            throw new BaseException(SDBError.SDB_SYS, "the pool has no information about address: " + addr);
        }
        if (deque.size() == 0) {
            throw new BaseException(SDBError.SDB_SYS, "the pool has no information about address: " + addr);
        }
        if (!deque.remove(connItem)) {
            throw new BaseException(SDBError.SDB_SYS, "the pool has no information about address: " + addr);
        }
        if (deque.size() == 0) {
            CountInfo countInfo = this._countInfoMap.get(addr);
            this._countInfoSet.remove(countInfo);
            countInfo.setHasLeftIdleConn(false);
            this._countInfoSet.add(countInfo);
        }
    }

    @Override
    public synchronized void updateUsedConnItemCount(ConnItem connItem, int change) {
        String addr = connItem.getAddr();
        if (this._countInfoMap.containsKey(addr)) {
            CountInfo countInfo = this._countInfoMap.get(addr);
            if (countInfo == null) {
                throw new BaseException(SDBError.SDB_SYS, "the pool has no information about address: " + addr);
            }
            this._countInfoSet.remove(countInfo);
            countInfo.changeCount(change);
            this._countInfoSet.add(countInfo);
        }
    }

    @Override
    public synchronized String getAddress() {
        CountInfo info = this._countInfoSet.higher(_dumpCountInfo);
        if (info == null) {
            try {
                info = this._countInfoSet.first();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        return info.getAddress();
    }

    @Override
    public synchronized void addAddress(String addr) {
        ArrayDeque<ConnItem> deque = this._idleConnItemMap.get(addr);
        if (deque == null) {
            this._idleConnItemMap.put(addr, new ArrayDeque());
            CountInfo info = new CountInfo(addr, 0, false);
            this._countInfoMap.put(addr, info);
            this._countInfoSet.add(info);
        }
    }

    @Override
    public synchronized List<ConnItem> removeAddress(String addr) {
        ArrayList<ConnItem> list = new ArrayList<ConnItem>();
        if (this._idleConnItemMap.containsKey(addr)) {
            ArrayDeque<ConnItem> deque;
            CountInfo obj = this._countInfoMap.remove(addr);
            if (obj != null) {
                this._countInfoSet.remove(obj);
            }
            if ((deque = this._idleConnItemMap.remove(addr)) != null) {
                for (ConnItem item : deque) {
                    list.add(item);
                }
            }
        }
        return list;
    }

    private void _restoreIdleConnItemInfo(String addr) {
        this.addAddress(addr);
    }
}

