/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.datasource;

import com.sequoiadb.datasource.ConnItem;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

class ConnectionItemMgr {
    private int _capacity;
    private static long _sequenceNumber = -1L;
    private TreeSet<ConnItem> _idleItem = null;
    private TreeSet<ConnItem> _usedItem = null;

    public ConnectionItemMgr(int capacity, List<ConnItem> usedItems) {
        this._capacity = capacity;
        this._idleItem = new TreeSet();
        this._usedItem = new TreeSet();
        int initNum = 0;
        if (usedItems != null) {
            Iterator<ConnItem> itr = usedItems.iterator();
            while (itr.hasNext()) {
                this._usedItem.add(itr.next());
            }
            initNum = capacity > this._usedItem.size() ? capacity - this._usedItem.size() : 0;
        } else {
            initNum = capacity;
        }
        for (int i = 0; i < initNum; ++i) {
            this._idleItem.add(new ConnItem("", ++_sequenceNumber));
        }
    }

    public synchronized long getCurrentSequenceNumber() {
        return _sequenceNumber;
    }

    public synchronized int getCapacity() {
        return this._capacity;
    }

    public synchronized int getIdleItemNum() {
        return this._idleItem.size();
    }

    public synchronized int getUsedItemNum() {
        return this._usedItem.size();
    }

    public synchronized void resetCapacity(int capacity) {
        if (this._capacity < capacity) {
            for (int i = this._capacity; i < capacity; ++i) {
                this._idleItem.add(new ConnItem("", ++_sequenceNumber));
            }
        } else {
            ConnItem connItem;
            int deltaNum = this._capacity - capacity;
            while (deltaNum-- != 0 && (connItem = this._idleItem.pollFirst()) != null) {
            }
        }
        this._capacity = capacity;
    }

    public synchronized ConnItem getItem() {
        ConnItem connItem = this._idleItem.pollFirst();
        if (connItem != null) {
            connItem.setSequenceNumber(++_sequenceNumber);
            this._usedItem.add(connItem);
        }
        return connItem;
    }

    public synchronized void releaseItem(ConnItem item) {
        this._usedItem.remove(item);
        if (this._usedItem.size() + this._idleItem.size() < this._capacity) {
            item.setAddr("");
            this._idleItem.add(item);
        }
    }
}

