/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.datasource;

import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.datasource.ConnItem;
import com.sequoiadb.datasource.IConnectionPool;
import com.sequoiadb.datasource.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class IdleConnectionPool
implements IConnectionPool {
    private HashMap<ConnItem, Sequoiadb> _conns = new HashMap();

    IdleConnectionPool() {
    }

    @Override
    public synchronized Sequoiadb peek(ConnItem connItem) {
        return this._conns.get(connItem);
    }

    @Override
    public synchronized Sequoiadb poll(ConnItem connItem) {
        return this._conns.remove(connItem);
    }

    @Override
    public synchronized ConnItem poll(Sequoiadb sdb) {
        return null;
    }

    @Override
    public synchronized void insert(ConnItem pos, Sequoiadb sdb) {
        this._conns.put(pos, sdb);
    }

    @Override
    public synchronized Iterator<Pair> getIterator() {
        return new IdlePairIterator(this._conns.entrySet().iterator());
    }

    @Override
    public synchronized int count() {
        return this._conns.size();
    }

    @Override
    public synchronized boolean contains(Sequoiadb sdb) {
        return false;
    }

    @Override
    public synchronized List<ConnItem> clear() {
        ArrayList<ConnItem> list = new ArrayList<ConnItem>();
        for (ConnItem item : this._conns.keySet()) {
            list.add(item);
        }
        this._conns.clear();
        return list;
    }

    class IdlePairIterator
    implements Iterator<Pair> {
        Iterator<Map.Entry<ConnItem, Sequoiadb>> _entries;

        public IdlePairIterator(Iterator<Map.Entry<ConnItem, Sequoiadb>> entries) {
            this._entries = entries;
        }

        @Override
        public boolean hasNext() {
            return this._entries.hasNext();
        }

        @Override
        public Pair next() {
            Map.Entry<ConnItem, Sequoiadb> entry = this._entries.next();
            return new Pair(entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
        }
    }
}

