/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.exception;

import com.sequoiadb.exception.SDBError;
import java.util.Arrays;
import org.bson.BSONObject;

public class BaseException
extends RuntimeException {
    private static final long serialVersionUID = -6115487863398926195L;
    private int errcode;
    private SDBError error;
    private String detail;
    private BSONObject errorObject;

    public BaseException(SDBError error, String detail, Throwable e) {
        super(e);
        this.errcode = error.getErrorCode();
        this.error = error;
        this.detail = detail;
    }

    public BaseException(SDBError error, String detail) {
        this.errcode = error.getErrorCode();
        this.error = error;
        this.detail = detail;
    }

    public BaseException(SDBError error, Throwable e) {
        this(error, e.getMessage(), e);
    }

    public BaseException(SDBError error) {
        this(error, (String)null);
    }

    public BaseException(int errCode) {
        this(errCode, (String)null);
    }

    public BaseException(int errCode, String detail) {
        this.errcode = errCode;
        this.error = SDBError.getSDBError(errCode);
        this.detail = detail;
    }

    public BaseException(int errCode, String detail, BSONObject errorObject) {
        this.errcode = errCode;
        this.error = SDBError.getSDBError(errCode);
        this.detail = detail;
        this.errorObject = errorObject;
    }

    public BaseException(String errorType, Object ... objs) {
        this(SDBError.valueOf(errorType), Arrays.toString(objs));
    }

    public BaseException(int errorCode, Object ... objs) {
        this(errorCode, Arrays.toString(objs));
    }

    @Override
    public String getMessage() {
        if (this.detail != null && !this.detail.isEmpty()) {
            if (this.error != null) {
                return this.error.toString() + ", detail: " + this.detail;
            }
            return this.getErrorType() + "(" + this.errcode + "), detail: " + this.detail;
        }
        if (this.error != null) {
            return this.error.toString();
        }
        return this.getErrorType() + "(" + this.errcode + ")";
    }

    public String getErrorType() {
        return this.error != null ? this.error.getErrorType() : "SDB_UNKNOWN";
    }

    public int getErrorCode() {
        return this.errcode;
    }

    public BSONObject getErrorObject() {
        return this.errorObject;
    }
}

