/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.SdbRequest;
import com.sequoiadb.util.Helper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.bson.BSONObject;

public class AggregateRequest
extends SdbRequest {
    private static final int FIXED_LENGTH = 44;
    private static final int version = 1;
    private static final short w = 0;
    private static final short padding = 0;
    private static final int flag = 0;
    private byte[] clNameBytes;
    private List<byte[]> objsBytes;

    public AggregateRequest(String collectionName, List<BSONObject> objects) {
        this.opCode = 2019;
        this.length = 44;
        if (collectionName == null || collectionName.length() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "Collection name is null or empty");
        }
        if (objects == null || objects.size() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "Aggregate objects is null or empty");
        }
        try {
            this.clNameBytes = collectionName.getBytes("UTF-8");
            this.length += Helper.alignedSize(this.clNameBytes.length + 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new BaseException(SDBError.SDB_INVALIDARG, (Throwable)e);
        }
        this.objsBytes = new ArrayList<byte[]>(objects.size());
        for (BSONObject obj : objects) {
            byte[] objBytes = Helper.encodeBSONObj(obj);
            this.objsBytes.add(objBytes);
            this.length += Helper.alignedSize(objBytes.length);
        }
    }

    @Override
    protected void encodeBody(ByteBuffer out) {
        out.putInt(1);
        out.putShort((short)0);
        out.putShort((short)0);
        out.putInt(0);
        out.putInt(this.clNameBytes.length);
        out.put(this.clNameBytes);
        out.put((byte)0);
        int length = this.clNameBytes.length + 1;
        int paddingLen = Helper.alignedSize(length) - length;
        if (paddingLen > 0) {
            out.put(new byte[paddingLen]);
        }
        for (byte[] docBytes : this.objsBytes) {
            AggregateRequest.encodeBSONBytes(docBytes, out);
        }
    }
}

