/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.SdbRequest;
import com.sequoiadb.util.Helper;
import java.nio.ByteBuffer;
import org.bson.BasicBSONObject;

public class AuthRequest
extends SdbRequest {
    private static final String AUTH_USER = "User";
    private static final String AUTH_PASSWD = "Passwd";
    private byte[] bsonBytes;

    public AuthRequest(String userName, String password, AuthType type) {
        switch (type) {
            case Verify: {
                this.opCode = 7000;
                break;
            }
            case CreateUser: {
                this.opCode = 7001;
                break;
            }
            case DeleteUser: {
                this.opCode = 7002;
                break;
            }
            default: {
                throw new BaseException(SDBError.SDB_INVALIDARG, "Invalid auth type");
            }
        }
        String md5 = null;
        if (password != null) {
            md5 = Helper.md5(password);
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put(AUTH_USER, (Object)userName);
        obj.put(AUTH_PASSWD, (Object)md5);
        this.bsonBytes = Helper.encodeBSONObj(obj);
        this.length += Helper.alignedSize(this.bsonBytes.length);
    }

    @Override
    public void encodeBody(ByteBuffer out) {
        AuthRequest.encodeBSONBytes(this.bsonBytes, out);
    }

    public static enum AuthType {
        Verify,
        CreateUser,
        DeleteUser;

    }
}

