/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.SdbRequest;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class MessageRequest
extends SdbRequest {
    private byte[] messageBytes;

    public MessageRequest(String message) {
        this.length = 28;
        this.opCode = 1000;
        try {
            message = message == null ? "" : message;
            this.messageBytes = message.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BaseException(SDBError.SDB_INVALIDARG, (Throwable)e);
        }
        this.length += this.messageBytes.length + 1;
    }

    @Override
    protected void encodeBody(ByteBuffer out) {
        out.put(this.messageBytes);
        out.put((byte)0);
    }
}

