/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.SdbRequest;
import com.sequoiadb.util.Helper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class QueryRequest
extends SdbRequest {
    private static final byte[] EMPTY_BSON_BYTES = Helper.encodeBSONObj(new BasicBSONObject());
    private static final int ALIGNED_EMPTY_BSON_LENGTH = Helper.alignedSize(EMPTY_BSON_BYTES.length);
    private static final int FIXED_LENGTH = 60;
    private static final int version = 1;
    private static final short w = 0;
    private static final short padding = 0;
    private int flag;
    private long skipNum;
    private long returnedNum;
    private byte[] clNameBytes;
    private byte[] matcherBytes;
    private byte[] selectorBytes;
    private byte[] orderBytes;
    private byte[] hintBytes;

    public QueryRequest(String collectionName, BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, long skipNum, long returnedNum, int flag) {
        this.opCode = 2004;
        this.length = 60;
        this.flag = flag;
        this.skipNum = skipNum;
        if (returnedNum < 0L) {
            returnedNum = -1L;
        }
        this.returnedNum = returnedNum;
        if (collectionName == null || collectionName.length() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "Collection name or command is null or empty");
        }
        try {
            this.clNameBytes = collectionName.getBytes("UTF-8");
            this.length += Helper.alignedSize(this.clNameBytes.length + 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new BaseException(SDBError.SDB_INVALIDARG, (Throwable)e);
        }
        if (matcher == null) {
            this.matcherBytes = (byte[])EMPTY_BSON_BYTES.clone();
            this.length += ALIGNED_EMPTY_BSON_LENGTH;
        } else {
            this.matcherBytes = Helper.encodeBSONObj(matcher);
            this.length += Helper.alignedSize(this.matcherBytes.length);
        }
        if (selector == null) {
            this.selectorBytes = (byte[])EMPTY_BSON_BYTES.clone();
            this.length += ALIGNED_EMPTY_BSON_LENGTH;
        } else {
            this.selectorBytes = Helper.encodeBSONObj(selector);
            this.length += Helper.alignedSize(this.selectorBytes.length);
        }
        if (orderBy == null) {
            this.orderBytes = (byte[])EMPTY_BSON_BYTES.clone();
            this.length += ALIGNED_EMPTY_BSON_LENGTH;
        } else {
            this.orderBytes = Helper.encodeBSONObj(orderBy);
            this.length += Helper.alignedSize(this.orderBytes.length);
        }
        if (hint == null) {
            this.hintBytes = (byte[])EMPTY_BSON_BYTES.clone();
            this.length += ALIGNED_EMPTY_BSON_LENGTH;
        } else {
            this.hintBytes = Helper.encodeBSONObj(hint);
            this.length += Helper.alignedSize(this.hintBytes.length);
        }
    }

    @Override
    protected void encodeBody(ByteBuffer out) {
        out.putInt(1);
        out.putShort((short)0);
        out.putShort((short)0);
        out.putInt(this.flag);
        out.putInt(this.clNameBytes.length);
        out.putLong(this.skipNum);
        out.putLong(this.returnedNum);
        out.put(this.clNameBytes);
        out.put((byte)0);
        int length = this.clNameBytes.length + 1;
        int paddingLen = Helper.alignedSize(length) - length;
        if (paddingLen > 0) {
            out.put(new byte[paddingLen]);
        }
        QueryRequest.encodeBSONBytes(this.matcherBytes, out);
        QueryRequest.encodeBSONBytes(this.selectorBytes, out);
        QueryRequest.encodeBSONBytes(this.orderBytes, out);
        QueryRequest.encodeBSONBytes(this.hintBytes, out);
    }
}

