/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.SdbRequest;
import com.sequoiadb.util.Helper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class SequenceFetchRequest
extends SdbRequest {
    private static final byte[] EMPTY_BSON_BYTES = Helper.encodeBSONObj(new BasicBSONObject());
    private static final int ALIGNED_EMPTY_BSON_LENGTH = Helper.alignedSize(EMPTY_BSON_BYTES.length);
    private static final int FIXED_LENGTH = 60;
    private static final int version = 1;
    private static final short w = 0;
    private static final short padding = 0;
    private int flag;
    private long skipNum;
    private long returnedNum;
    private byte[] clNameBytes;
    private byte[] matcherBytes;
    private byte[] selectorBytes;
    private byte[] orderBytes;
    private byte[] hintBytes;

    public SequenceFetchRequest(BSONObject matcher) {
        this.opCode = 2022;
        this.length = 60;
        this.flag = 0;
        this.skipNum = 0L;
        this.returnedNum = -1L;
        try {
            this.clNameBytes = "".getBytes("UTF-8");
            this.length += Helper.alignedSize(this.clNameBytes.length + 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new BaseException(SDBError.SDB_INVALIDARG, (Throwable)e);
        }
        if (matcher == null) {
            this.matcherBytes = (byte[])EMPTY_BSON_BYTES.clone();
            this.length += ALIGNED_EMPTY_BSON_LENGTH;
        } else {
            this.matcherBytes = Helper.encodeBSONObj(matcher);
            this.length += Helper.alignedSize(this.matcherBytes.length);
        }
        this.selectorBytes = (byte[])EMPTY_BSON_BYTES.clone();
        this.length += ALIGNED_EMPTY_BSON_LENGTH;
        this.orderBytes = (byte[])EMPTY_BSON_BYTES.clone();
        this.length += ALIGNED_EMPTY_BSON_LENGTH;
        this.hintBytes = (byte[])EMPTY_BSON_BYTES.clone();
        this.length += ALIGNED_EMPTY_BSON_LENGTH;
    }

    @Override
    protected void encodeBody(ByteBuffer out) {
        out.putInt(1);
        out.putShort((short)0);
        out.putShort((short)0);
        out.putInt(this.flag);
        out.putInt(this.clNameBytes.length);
        out.putLong(this.skipNum);
        out.putLong(this.returnedNum);
        out.put(this.clNameBytes);
        out.put((byte)0);
        int length = this.clNameBytes.length + 1;
        int paddingLen = Helper.alignedSize(length) - length;
        if (paddingLen > 0) {
            out.put(new byte[paddingLen]);
        }
        SequenceFetchRequest.encodeBSONBytes(this.matcherBytes, out);
        SequenceFetchRequest.encodeBSONBytes(this.selectorBytes, out);
        SequenceFetchRequest.encodeBSONBytes(this.orderBytes, out);
        SequenceFetchRequest.encodeBSONBytes(this.hintBytes, out);
    }
}

