/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.SdbRequest;
import com.sequoiadb.util.Helper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class UpdateRequest
extends SdbRequest {
    private static final int FIXED_LENGTH = 44;
    private static final byte[] EMPTY_BSON_BYTES = Helper.encodeBSONObj(new BasicBSONObject());
    private static final int ALIGNED_EMPTY_BSON_LENGTH = Helper.alignedSize(EMPTY_BSON_BYTES.length);
    private static final int version = 1;
    private static final short w = 0;
    private static final short padding = 0;
    private int flag = 0;
    private byte[] clNameBytes;
    private byte[] matcherBytes;
    private byte[] modifierBytes;
    private byte[] hintBytes;

    public UpdateRequest(String collectionName, BSONObject matcher, BSONObject modifier, BSONObject hint, int flag) {
        this.opCode = 2001;
        this.length = 44;
        if (collectionName == null || collectionName.length() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "Collection name is null or empty");
        }
        try {
            this.clNameBytes = collectionName.getBytes("UTF-8");
            this.length += Helper.alignedSize(this.clNameBytes.length + 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new BaseException(SDBError.SDB_INVALIDARG, (Throwable)e);
        }
        if (matcher == null) {
            this.matcherBytes = (byte[])EMPTY_BSON_BYTES.clone();
            this.length += ALIGNED_EMPTY_BSON_LENGTH;
        } else {
            this.matcherBytes = Helper.encodeBSONObj(matcher);
            this.length += Helper.alignedSize(this.matcherBytes.length);
        }
        if (modifier == null) {
            this.modifierBytes = (byte[])EMPTY_BSON_BYTES.clone();
            this.length += ALIGNED_EMPTY_BSON_LENGTH;
        } else {
            this.modifierBytes = Helper.encodeBSONObj(modifier);
            this.length += Helper.alignedSize(this.modifierBytes.length);
        }
        if (hint == null) {
            this.hintBytes = (byte[])EMPTY_BSON_BYTES.clone();
            this.length += ALIGNED_EMPTY_BSON_LENGTH;
        } else {
            this.hintBytes = Helper.encodeBSONObj(hint);
            this.length += Helper.alignedSize(this.hintBytes.length);
        }
        this.flag = flag;
    }

    @Override
    protected void encodeBody(ByteBuffer out) {
        out.putInt(1);
        out.putShort((short)0);
        out.putShort((short)0);
        out.putInt(this.flag);
        out.putInt(this.clNameBytes.length);
        out.put(this.clNameBytes);
        out.put((byte)0);
        int length = this.clNameBytes.length + 1;
        int paddingLen = Helper.alignedSize(length) - length;
        if (paddingLen > 0) {
            out.put(new byte[paddingLen]);
        }
        UpdateRequest.encodeBSONBytes(this.matcherBytes, out);
        UpdateRequest.encodeBSONBytes(this.modifierBytes, out);
        UpdateRequest.encodeBSONBytes(this.hintBytes, out);
    }
}

