/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.net;

import com.sequoiadb.base.ConfigOptions;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.net.IConnection;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TCPConnection
implements IConnection {
    private InetSocketAddress address;
    private ConfigOptions options;
    private Socket socket;
    private InputStream input;
    private OutputStream output;
    private String remoteAddressInfo;

    public TCPConnection(InetSocketAddress address, ConfigOptions options) {
        if (address == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "address is null");
        }
        if (options == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "options is null");
        }
        this.address = address;
        this.options = options;
        this.remoteAddressInfo = "remote address[" + address.toString() + "]";
    }

    @Override
    public void connect() throws BaseException {
        if (this.socket != null) {
            return;
        }
        long sleepTime = 100L;
        long maxAutoConnectRetryTime = this.options.getMaxAutoConnectRetryTime();
        long start = System.currentTimeMillis();
        while (true) {
            try {
                this.socket = this.options.getUseSSL() ? SSLContextHelper.getSSLContext().getSocketFactory().createSocket() : new Socket();
                this.socket.connect(this.address, this.options.getConnectTimeout());
                this.socket.setTcpNoDelay(!this.options.getUseNagle());
                this.socket.setKeepAlive(this.options.getSocketKeepAlive());
                this.socket.setSoTimeout(this.options.getSocketTimeout());
                this.input = new BufferedInputStream(this.socket.getInputStream());
                this.output = this.socket.getOutputStream();
                return;
            }
            catch (IOException ioe) {
                BaseException lastError = new BaseException(SDBError.SDB_NETWORK, "failed to connect to " + this.address.toString(), ioe);
                this.close();
                long executedTime = System.currentTimeMillis() - start;
                if (executedTime >= maxAutoConnectRetryTime) {
                    throw lastError;
                }
                if (sleepTime + executedTime > maxAutoConnectRetryTime) {
                    sleepTime = maxAutoConnectRetryTime - executedTime;
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                sleepTime *= 2L;
                continue;
            }
            break;
        }
    }

    @Override
    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    @Override
    public boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    @Override
    public String getRemoteAddress() {
        if (this.socket == null) {
            return null;
        }
        return this.socket.getRemoteSocketAddress().toString();
    }

    @Override
    public String getLocalAddress() {
        if (this.socket == null) {
            return null;
        }
        return this.socket.getLocalSocketAddress().toString();
    }

    @Override
    public byte[] receive(int length) throws BaseException {
        byte[] buf = new byte[length];
        this.receive(buf, 0, length);
        return buf;
    }

    @Override
    public void receive(byte[] buf, int off, int length) throws BaseException {
        int size;
        if (this.isClosed()) {
            throw new BaseException(SDBError.SDB_NOT_CONNECTED, this.remoteAddressInfo);
        }
        try {
            int retSize;
            for (size = 0; size < length && (retSize = this.input.read(buf, off + size, length - size)) != -1; size += retSize) {
            }
        }
        catch (IOException e) {
            this.close();
            throw new BaseException(SDBError.SDB_NETWORK, this.remoteAddressInfo, e);
        }
        if (size != length) {
            this.close();
            throw new BaseException(SDBError.SDB_NETWORK, String.format("%s, required %d bytes, but only read %s bytes", this.remoteAddressInfo, length, size));
        }
    }

    @Override
    public void send(ByteBuffer buffer) throws BaseException {
        if (buffer == null) {
            throw new BaseException(SDBError.SDB_SYS, this.remoteAddressInfo + ", byteBuffer is null");
        }
        if (!buffer.hasArray()) {
            throw new BaseException(SDBError.SDB_SYS, this.remoteAddressInfo + ", byteBuffer has no array");
        }
        this.send(buffer.array(), 0, buffer.limit());
    }

    @Override
    public void send(byte[] msg) throws BaseException {
        this.send(msg, 0, msg.length);
    }

    @Override
    public void send(byte[] msg, int off, int length) throws BaseException {
        if (this.isClosed()) {
            throw new BaseException(SDBError.SDB_NOT_CONNECTED, this.remoteAddressInfo);
        }
        try {
            this.output.write(msg, off, length);
        }
        catch (IOException e) {
            this.close();
            throw new BaseException(SDBError.SDB_NETWORK, this.remoteAddressInfo, e);
        }
    }

    @Override
    public void setSoTimeout(int timeout) throws BaseException {
        try {
            if (this.socket != null) {
                this.socket.setSoTimeout(timeout);
            }
        }
        catch (SocketException e) {
            throw new BaseException(SDBError.SDB_NETWORK, "failed to modify soTimeout", e);
        }
    }

    private static class SSLContextHelper {
        private static volatile SSLContext sslContext = null;

        private SSLContextHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static SSLContext getSSLContext() throws BaseException {
            if (sslContext != null) return sslContext;
            Class<SSLContextHelper> clazz = SSLContextHelper.class;
            synchronized (SSLContextHelper.class) {
                if (sslContext != null) return sslContext;
                try {
                    X509TrustManager tm = new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        }
                    };
                    SSLContext ctx = SSLContext.getInstance("SSL");
                    ctx.init(null, new TrustManager[]{tm}, null);
                    sslContext = ctx;
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new BaseException(SDBError.SDB_NETWORK, (Throwable)nsae);
                }
                catch (KeyManagementException kme) {
                    throw new BaseException(SDBError.SDB_NETWORK, (Throwable)kme);
                }
                return sslContext;
            }
        }
    }
}

