/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.util;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.util.EN_MATCH_RESULT;
import com.sequoiadb.util.Helper;
import com.sequoiadb.util.KeyValuePair;
import com.sequoiadb.util.SdbDecryptUserInfo;
import com.sequoiadb.util.SdbDesEcbDecryptor;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class SdbDecrypt {
    private static final String SEP_CLUSTER = "@";
    private static final String SEP_PASSWORD = ":";
    private static final int MAX_TOKEN_SIZE = 256;

    public SdbDecryptUserInfo parseCipherFile(String user, String token, File passwdFile) {
        if (null == user || null == passwdFile) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "user or passwdFile is null");
        }
        if (!passwdFile.exists() || !passwdFile.isFile()) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "file is not exist or is not file:file=" + passwdFile.getAbsolutePath());
        }
        SdbDecryptUserInfo userInfo = this.parseFile(user, passwdFile);
        String encryptPasswd = userInfo.getPasswd();
        if (null == encryptPasswd) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "can't find user's password info from file:file=" + passwdFile);
        }
        String descryptPasswd = this.decryptPasswd(encryptPasswd, token);
        userInfo.setPasswd(descryptPasswd);
        return userInfo;
    }

    public String decryptPasswd(String encryptPasswd) {
        return this.decryptPasswd(encryptPasswd, null);
    }

    public String decryptPasswd(String encryptPasswd, String token) {
        int DECRYPT_LENGTH = 8;
        int KEY_LENGTH = 8;
        if (null == encryptPasswd) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "encryptPasswd is null");
        }
        KeyValuePair kv = this.parsePasswd(encryptPasswd);
        byte[] key = kv.getKey();
        if (null != token) {
            int maxTokenLen = token.length() < 256 ? token.length() : 256;
            token = token.substring(0, maxTokenLen);
            byte[] t = null;
            try {
                t = token.getBytes("UTF-8");
            }
            catch (Exception e) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "token is invalid:token=" + token, e);
            }
            int length = t.length + key.length;
            byte[] tmp = new byte[length];
            System.arraycopy(t, 0, tmp, 0, t.length);
            System.arraycopy(key, 0, tmp, t.length, key.length);
            key = tmp;
        }
        byte[] decryptKey = Helper.sha256(key);
        byte[] tmp = new byte[8];
        for (int i = 0; i < tmp.length && i < decryptKey.length; ++i) {
            tmp[i] = decryptKey[i];
        }
        decryptKey = tmp;
        SdbDesEcbDecryptor decryptor = new SdbDesEcbDecryptor(decryptKey);
        byte[] result = new byte[kv.getValue().length];
        byte[] rSub = new byte[8];
        for (int i = 0; i < kv.getValue().length / 8; ++i) {
            System.arraycopy(kv.getValue(), i * 8, rSub, 0, 8);
            rSub = decryptor.desDecrypt(rSub);
            System.arraycopy(rSub, 0, result, i * 8, 8);
        }
        int paddingNum = 0;
        for (int i = result.length - 1; i >= 0 && result[i] == 0; --i) {
            ++paddingNum;
        }
        return new String(result, 0, result.length - paddingNum);
    }

    private KeyValuePair parsePasswd(String encryptPasswd) {
        String lengthStr = encryptPasswd.substring(0, 2);
        byte[] lengthByte = Helper.hexToByte(lengthStr);
        String epStr = encryptPasswd.substring(2);
        byte[] epByte = Helper.hexToByte(epStr);
        if (epByte.length <= 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "encryptPasswd is invalid:passwd=" + encryptPasswd);
        }
        byte keyOff1 = lengthByte[0];
        if (keyOff1 >= epByte.length || keyOff1 < 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "encryptPasswd is invalid:passwd=" + encryptPasswd + ",keyOff1=" + keyOff1);
        }
        int keyLen1 = epByte[keyOff1] + 2;
        if (keyOff1 + keyLen1 > epByte.length) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "encryptPasswd is invalid:passwd=" + encryptPasswd + ",keyLen1=" + keyLen1);
        }
        byte keyOff2 = epByte[keyOff1 + keyLen1 - 1];
        if (keyOff2 >= epByte.length || keyOff2 <= keyOff1 + keyLen1) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "encryptPasswd is invalid:passwd=" + encryptPasswd + ",keyOff2=" + keyOff2);
        }
        int keyLen2 = epByte[keyOff2] + 2;
        if (keyOff2 + keyLen2 > epByte.length) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "encryptPasswd is invalid:passwd=" + encryptPasswd + ",keyLen2=" + keyLen2);
        }
        byte keyOff3 = epByte[keyOff2 + keyLen2 - 1];
        if (keyOff3 >= epByte.length || keyOff3 <= keyOff2 + keyLen2) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "encryptPasswd is invalid:passwd=" + encryptPasswd + ",keyOff3=" + keyOff3);
        }
        int keyLen3 = epByte[keyOff3] + 1;
        if (keyOff3 + keyLen3 > epByte.length) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "encryptPasswd is invalid:passwd=" + encryptPasswd + ",keyLen3=" + keyLen3);
        }
        int realKeyLen = keyLen1 - 2 + keyLen2 - 2 + keyLen3 - 1;
        if (realKeyLen < 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "encryptPasswd is invalid:passwd=" + encryptPasswd + ",realKeyLen=" + realKeyLen);
        }
        byte[] realKey = new byte[realKeyLen];
        int off = 0;
        System.arraycopy(epByte, keyOff1 + 1, realKey, off, keyLen1 - 2);
        System.arraycopy(epByte, keyOff2 + 1, realKey, off += keyLen1 - 2, keyLen2 - 2);
        System.arraycopy(epByte, keyOff3 + 1, realKey, off += keyLen2 - 2, keyLen3 - 1);
        int realValueLen = epByte.length - keyLen1 - keyLen2 - keyLen3;
        if (realValueLen < 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "encryptPasswd is invalid:passwd=" + encryptPasswd + ",realValueLen=" + realValueLen);
        }
        byte[] realValue = new byte[realValueLen];
        off = 0;
        System.arraycopy(epByte, 0, realValue, off, keyOff1);
        System.arraycopy(epByte, keyOff1 + keyLen1, realValue, off += keyOff1, keyOff2 - keyOff1 - keyLen1);
        System.arraycopy(epByte, keyOff2 + keyLen2, realValue, off += keyOff2 - keyOff1 - keyLen1, keyOff3 - keyOff2 - keyLen2);
        off += keyOff3 - keyOff2 - keyLen2;
        if (epByte.length > keyOff3 + keyLen3) {
            System.arraycopy(epByte, keyOff3 + keyLen3, realValue, off, epByte.length - keyOff3 - keyLen3);
        }
        KeyValuePair kv = new KeyValuePair();
        kv.setKey(realKey);
        kv.setValue(realValue);
        return kv;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SdbDecryptUserInfo parseFile(String user, File passwdFile) {
        SdbDecryptUserInfo info = new SdbDecryptUserInfo();
        info.setUserName(user);
        int idxCluster = user.indexOf(SEP_CLUSTER);
        if (idxCluster != -1) {
            info.setUserName(user.substring(0, idxCluster));
            info.setClusterName(user.substring(idxCluster + 1));
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(passwdFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                EN_MATCH_RESULT r = this.matchAndSet(line, info);
                if (EN_MATCH_RESULT.perfect_match != r) continue;
                SdbDecryptUserInfo sdbDecryptUserInfo = info;
                this.close(br);
                return sdbDecryptUserInfo;
            }
        }
        catch (Exception e) {
            try {
                throw new BaseException(SDBError.SDB_INVALIDARG, "read file failed:file=" + passwdFile, e);
            }
            catch (Throwable throwable) {
                this.close(br);
                throw throwable;
            }
        }
        {
            SdbDecryptUserInfo sdbDecryptUserInfo = info;
            this.close(br);
            return sdbDecryptUserInfo;
        }
    }

    private EN_MATCH_RESULT matchAndSet(String line, SdbDecryptUserInfo info) {
        int idxPasswd = line.lastIndexOf(SEP_PASSWORD);
        if (-1 == idxPasswd) {
            return EN_MATCH_RESULT.mismatch;
        }
        String user = line.substring(0, idxPasswd);
        String cluster = null;
        int idxCluster = user.indexOf(SEP_CLUSTER);
        if (idxCluster != -1) {
            cluster = user.substring(idxCluster + 1);
            user = user.substring(0, idxCluster);
        }
        if (user.equals(info.getUserName())) {
            if (null == cluster && null == info.getClusterName()) {
                info.setPasswd(line.substring(idxPasswd + 1));
                return EN_MATCH_RESULT.perfect_match;
            }
            if (null != cluster && null != info.getClusterName()) {
                if (cluster.equals(info.getClusterName())) {
                    info.setPasswd(line.substring(idxPasswd + 1));
                    return EN_MATCH_RESULT.perfect_match;
                }
                return EN_MATCH_RESULT.mismatch;
            }
            info.setPasswd(line.substring(idxPasswd + 1));
            return EN_MATCH_RESULT.match;
        }
        return EN_MATCH_RESULT.mismatch;
    }

    public SdbDecryptUserInfo parseCipherFile(String user, File passwdFile) {
        return this.parseCipherFile(user, null, passwdFile);
    }

    private void close(Closeable c) {
        if (null != c) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

