/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.util.lobid;

import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class UtilLobID {
    private static Random r = new Random();
    private static AtomicInteger atomicSerial = new AtomicInteger(r.nextInt(100000));
    private static final byte[] isOddArray = new byte[]{0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0};
    private long seconds;
    private byte oddCheck;
    private short id;
    private int serial;

    public UtilLobID(Date d, short id) {
        this.seconds = d.getTime() / 1000L;
        this.setOddCheckBit();
        this.id = id;
        this.serial = atomicSerial.getAndIncrement();
    }

    public UtilLobID(short id) {
        this.seconds = System.currentTimeMillis() / 1000L;
        this.setOddCheckBit();
        this.id = id;
        this.serial = atomicSerial.getAndIncrement();
    }

    public UtilLobID(String s) {
        if (!this.isValid(s)) {
            throw new IllegalArgumentException("invalid ObjectId [" + s + "]");
        }
        byte[] b = new byte[12];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        this.fromByteArray(b);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public short getID() {
        return this.id;
    }

    public int getSerial() {
        return this.serial;
    }

    public boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        int len = s.length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    private void setOddCheckBit() {
        this.oddCheck = 0;
        for (int i = 5; i >= 0; --i) {
            int s = (int)(this.seconds >> i * 8 & 0xFFL);
            if (this.isOdd(s)) continue;
            this.oddCheck = (byte)(this.oddCheck | 1 << i);
        }
    }

    private boolean bitIsOne(byte value, int pos) {
        return (value & 1 << pos) > 0;
    }

    private void checkOddBit() {
        for (int i = 5; i >= 0; --i) {
            int s = (int)(this.seconds >> i * 8 & 0xFFL);
            if (this.isOdd(s) && !this.bitIsOne(this.oddCheck, i) || !this.isOdd(s) && this.bitIsOne(this.oddCheck, i)) continue;
            throw new IllegalArgumentException("check odd bit failed:seconds=" + this.seconds + ",oddCheck=" + this.oddCheck);
        }
    }

    public String toString() {
        byte[] b = this.toByteArray();
        StringBuilder buf = new StringBuilder(24);
        for (int i = 0; i < b.length; ++i) {
            int x = b[i] & 0xFF;
            String s = Integer.toHexString(x);
            if (s.length() == 1) {
                buf.append("0");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    private byte[] toByteArray() {
        int i;
        byte[] array = new byte[12];
        int arrayIdx = 0;
        for (i = 5; i >= 0; --i) {
            array[arrayIdx++] = (byte)(this.seconds >> i * 8 & 0xFFL);
        }
        array[arrayIdx++] = this.oddCheck;
        for (i = 1; i >= 0; --i) {
            array[arrayIdx++] = (byte)(this.id >> i * 8 & 0xFF);
        }
        for (i = 2; i >= 0; --i) {
            array[arrayIdx++] = (byte)(this.serial >> i * 8 & 0xFF);
        }
        return array;
    }

    private void fromByteArray(byte[] array) {
        int i;
        int arrayIdx = 0;
        this.seconds = 0L;
        for (i = 5; i >= 0; --i) {
            this.seconds |= (long)((array[arrayIdx++] & 0xFF) << i * 8);
        }
        this.oddCheck = array[arrayIdx++];
        this.checkOddBit();
        this.id = 0;
        for (i = 1; i >= 0; --i) {
            this.id = (short)(this.id | (array[arrayIdx++] & 0xFF) << i * 8);
        }
        this.serial = 0;
        for (i = 2; i >= 0; --i) {
            this.serial |= (array[arrayIdx++] & 0xFF) << i * 8;
        }
    }

    private boolean isOdd(int v) {
        return 1 == isOddArray[v];
    }

    public static void main(String[] args) {
        Date d = new Date(1560549792000L);
        UtilLobID id = new UtilLobID(d, -24440);
        UtilLobID id2 = new UtilLobID(d, -24440);
        System.out.println(id);
        System.out.println(id2);
        UtilLobID id3 = new UtilLobID(id2.toString());
        System.out.println(id3);
    }
}

