/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.Serializable;
import java.math.BigDecimal;
import org.bson.util.JSON;

public class BSONDecimal
implements Comparable<BSONDecimal>,
Serializable {
    private static final long serialVersionUID = 8374882369691286577L;
    private static final int DECIMAL_SIGN_MASK = 49152;
    private static final int SDB_DECIMAL_POS = 0;
    private static final int SDB_DECIMAL_NEG = 16384;
    private static final int SDB_DECIMAL_SPECIAL_SIGN = 49152;
    private static final int SDB_DECIMAL_SPECIAL_NAN = 0;
    private static final int SDB_DECIMAL_SPECIAL_MIN = 1;
    private static final int SDB_DECIMAL_SPECIAL_MAX = 2;
    private static final int DECIMAL_DSCALE_MASK = 16383;
    private static final int DECIMAL_MAX_PRECISION = 1000;
    private static final int DECIMAL_MAX_DWEIGHT = 131072;
    private static final int DECIMAL_MAX_DSCALE = 16383;
    private static final int DECIMAL_NBASE = 10000;
    private static final int DECIMAL_HALF_NBASE = 5000;
    private static final int DECIMAL_DEC_DIGITS = 4;
    private static final int SIZEOF_SHORT = 2;
    private String _value;
    private int _precision;
    private int _scale;
    private int _mid_typemod;
    private int _mid_ndigits;
    private int _mid_sign;
    private int _mid_dscale;
    private int _mid_weight;
    private short[] _mid_digits;
    private int _mid_digits_idx = 0;
    private boolean _hasCarry = false;
    private int _size;
    private int _typemod;
    private short _signscale;
    private short _weight;
    private short[] _digits;
    private static final int[] round_powers = new int[]{0, 1000, 100, 10};
    public static final int DECIMAL_HEADER_SIZE = 12;

    public String getValue() {
        return this._value;
    }

    public int getPrecision() {
        return this._precision;
    }

    public int getScale() {
        return this._scale;
    }

    public int getSize() {
        return this._size;
    }

    public int getTypemod() {
        return this._typemod;
    }

    public short getSignScale() {
        return this._signscale;
    }

    public short getWeight() {
        return this._weight;
    }

    public short[] getDigits() {
        short[] retDigits = new short[this._mid_ndigits];
        if (this._mid_digits != null && this._mid_digits.length > 0) {
            if (!this._hasCarry) {
                System.arraycopy(this._mid_digits, 1, retDigits, 0, this._mid_ndigits);
            } else {
                System.arraycopy(this._mid_digits, 0, retDigits, 0, this._mid_ndigits);
            }
        }
        return retDigits;
    }

    public BSONDecimal(String value, int precision, int scale) {
        this._fromStringValue(value, precision, scale);
        this._value = this._getValue();
        if (!this._isSpecial(this)) {
            this._precision = precision;
            this._scale = scale;
        } else {
            this._precision = -1;
            this._scale = -1;
        }
    }

    public BSONDecimal(String value) {
        this(value, -1, -1);
    }

    public BSONDecimal(BigDecimal value) {
        if (value == null) {
            throw new IllegalArgumentException("decimal value can't be null");
        }
        String str = value.toString();
        this._fromStringValue(str, -1, -1);
        this._value = this._getValue();
        this._precision = -1;
        this._scale = -1;
    }

    public BSONDecimal(int size, int typemod, short signscale, short weight, short[] digits) {
        if (size < 12 || size == 12 && digits != null && digits.length != 0 || size > 12 && (digits == null || digits.length == 0)) {
            String message = String.format("Invalid arguments: size(%d), typemod(%d), signscale(%d), weight(%d), digits.length(%d).", size, typemod, signscale, weight, digits == null ? null : Integer.valueOf(digits.length));
            throw new IllegalArgumentException(message);
        }
        if (digits == null) {
            digits = new short[]{};
        }
        this._size = size;
        this._typemod = typemod;
        this._signscale = signscale;
        this._weight = weight;
        this._digits = new short[digits.length + 1];
        this._digits[0] = 0;
        System.arraycopy(digits, 0, this._digits, 1, digits.length);
        this._mid_typemod = this._typemod;
        this._mid_ndigits = digits.length;
        this._mid_sign = this._signscale & 0xC000;
        this._mid_dscale = this._signscale & 0x3FFF;
        this._mid_weight = this._weight;
        this._mid_digits = new short[this._digits.length];
        System.arraycopy(this._digits, 0, this._mid_digits, 0, this._digits.length);
        this._mid_digits_idx = 1;
        this._hasCarry = false;
        this._value = this._getValue();
        this._precision = this._getPrecision();
        this._scale = this._getScale();
    }

    public BigDecimal toBigDecimal() {
        if (this._isMax(this) || this._isMin(this) || this._isNan(this)) {
            throw new UnsupportedOperationException(String.format("can't convert %s to BigDecimal", this._getValue()));
        }
        return new BigDecimal(this.getValue());
    }

    public boolean isMax() {
        return this._isMax(this);
    }

    public boolean isMin() {
        return this._isMin(this);
    }

    public boolean isNan() {
        return this._isNan(this);
    }

    @Override
    public int compareTo(BSONDecimal other) {
        if (other == null) {
            return 1;
        }
        return this._compareTo(other);
    }

    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (!(x instanceof BSONDecimal)) {
            return false;
        }
        return this.compareTo((BSONDecimal)x) == 0;
    }

    public int hashCode() {
        String value = this._value;
        if (value.indexOf(".") > -1) {
            value = value.replaceAll("0+$", "");
            if ((value = value.replaceAll("[.]$", "")).isEmpty()) {
                value = "0";
            }
        }
        int hash = 17;
        hash = 37 * hash + 3700;
        hash = 37 * hash + value.hashCode();
        return hash;
    }

    public String toString() {
        return JSON.serialize(this);
    }

    private void _fromStringValue(String value, int precision, int scale) {
        boolean have_dp = false;
        int sign = 0;
        int dweight = -1;
        int ddigits = 0;
        int dscale = 0;
        int weight = -1;
        int ndigits = 0;
        int offset = 0;
        this._init(value, precision, scale);
        char[] cp = this._value.toCharArray();
        int cp_idx = 0;
        if (this._value.length() >= 3) {
            if (!(cp[0] != 'n' && cp[0] != 'N' || cp[1] != 'a' && cp[1] != 'A' || cp[2] != 'n' && cp[2] != 'N')) {
                this._setNan();
                this._update();
                return;
            }
            if (!(cp[0] != 'm' && cp[0] != 'M' || cp[1] != 'i' && cp[1] != 'I' || cp[2] != 'n' && cp[2] != 'N')) {
                this._setMin();
                this._update();
                return;
            }
            if (!(cp[0] != 'm' && cp[0] != 'M' || cp[1] != 'a' && cp[1] != 'A' || cp[2] != 'x' && cp[2] != 'X')) {
                this._setMax();
                this._update();
                return;
            }
            if (!(cp[0] != 'i' && cp[0] != 'I' || cp[1] != 'n' && cp[1] != 'N' || cp[2] != 'f' && cp[2] != 'F')) {
                this._setMax();
                this._update();
                return;
            }
            if (!(cp[0] != '-' || cp[1] != 'i' && cp[1] != 'I' || cp[2] != 'n' && cp[2] != 'N' || cp[3] != 'f' && cp[3] != 'F')) {
                this._setMin();
                this._update();
                return;
            }
        }
        switch (cp[cp_idx]) {
            case '+': {
                sign = 0;
                ++cp_idx;
                break;
            }
            case '-': {
                sign = 16384;
                ++cp_idx;
            }
        }
        if (cp[cp_idx] == '.') {
            have_dp = true;
            ++cp_idx;
        }
        if (!Character.isDigit(cp[cp_idx])) {
            throw new IllegalArgumentException("invalid decimal: " + this._value);
        }
        int decdigits_idx = 0;
        int decdigitsnum = cp.length - cp_idx + 8;
        int[] decdigits = new int[decdigitsnum];
        decdigits_idx = 4;
        while (cp_idx < cp.length) {
            if (Character.isDigit(cp[cp_idx])) {
                decdigits[decdigits_idx++] = Character.digit(cp[cp_idx++], 10);
                if (!have_dp) {
                    if (++dweight < 132072) continue;
                    throw new IllegalArgumentException("the integer part of the value is out of bound");
                }
                if (++dscale <= 17383) continue;
                throw new IllegalArgumentException("the decimal part of the value is out of bound");
            }
            if (cp[cp_idx] == '.') {
                if (have_dp) {
                    throw new IllegalArgumentException("invalid decimal point in decimal: " + this._value);
                }
                have_dp = true;
                ++cp_idx;
                continue;
            }
            if (cp[cp_idx] == 'e' || cp[cp_idx] == 'E') break;
            throw new IllegalArgumentException("invalid digit in decimal: " + this._value);
        }
        ddigits = decdigits_idx - 4;
        if (cp_idx < cp.length && (cp[cp_idx] == 'e' || cp[cp_idx] == 'E')) {
            long exponent = 0L;
            if (++cp_idx < cp.length && cp[cp_idx] == '+') {
                ++cp_idx;
            }
            String strexponent = String.valueOf(cp, cp_idx, cp.length - cp_idx);
            try {
                exponent = Long.parseLong(strexponent);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid exponent in decimal: " + this._value);
            }
            if (exponent > 1000L || exponent < -1000L) {
                throw new IllegalArgumentException("exponent in decimal: " + this._value + " should be in the bound of [-1000, 1000]");
            }
            dweight += (int)exponent;
            if ((dscale -= (int)exponent) < 0) {
                dscale = 0;
            }
        }
        if (dweight >= 131072) {
            throw new IllegalArgumentException("the integer part of the value is out of bound");
        }
        if (dscale > 16383) {
            throw new IllegalArgumentException("the decimal part of the value is out of bound");
        }
        weight = dweight >= 0 ? (dweight + 1 + 4 - 1) / 4 - 1 : -((-dweight - 1) / 4 + 1);
        offset = (weight + 1) * 4 - (dweight + 1);
        ndigits = (ddigits + offset + 4 - 1) / 4;
        this._alloc(ndigits);
        this._mid_sign = sign;
        this._mid_weight = weight;
        this._mid_dscale = dscale;
        decdigits_idx = 4 - offset;
        while (ndigits-- > 0) {
            this._mid_digits[this._mid_digits_idx++] = (short)(((decdigits[decdigits_idx] * 10 + decdigits[decdigits_idx + 1]) * 10 + decdigits[decdigits_idx + 2]) * 10 + decdigits[decdigits_idx + 3]);
            decdigits_idx += 4;
        }
        this._strip();
        this._apply_typemod();
        this._update();
    }

    private String _getValue() {
        short dig = 0;
        short d1 = 0;
        int d = 0;
        String retStr = null;
        int expect_char_size = this._getExpectCharSize();
        char[] cp = new char[expect_char_size];
        int cp_idx = 0;
        int cp_idx_end = 0;
        if (this._isNan(this)) {
            cp[0] = 78;
            cp[1] = 97;
            cp[2] = 78;
            retStr = new String(cp);
            return retStr;
        }
        if (this._isMin(this)) {
            cp[0] = 77;
            cp[1] = 73;
            cp[2] = 78;
            retStr = new String(cp);
            return retStr;
        }
        if (this._isMax(this)) {
            cp[0] = 77;
            cp[1] = 65;
            cp[2] = 88;
            retStr = new String(cp);
            return retStr;
        }
        if (this._mid_sign == 16384) {
            cp[cp_idx++] = 45;
        }
        if (this._mid_weight < 0) {
            d = this._mid_weight + 1;
            cp[cp_idx++] = 48;
        } else {
            for (d = 0; d <= this._mid_weight; ++d) {
                dig = this._hasCarry ? (d < this._mid_ndigits ? this._mid_digits[d] : (short)0) : (d < this._mid_ndigits ? this._mid_digits[1 + d] : (short)0);
                boolean putit = d > 0;
                d1 = (short)(dig / 1000);
                dig = (short)(dig - d1 * 1000);
                if (putit |= d1 > 0) {
                    cp[cp_idx++] = (char)(d1 + 48);
                }
                d1 = (short)(dig / 100);
                dig = (short)(dig - d1 * 100);
                if (putit |= d1 > 0) {
                    cp[cp_idx++] = (char)(d1 + 48);
                }
                d1 = (short)(dig / 10);
                dig = (short)(dig - d1 * 10);
                if (putit |= d1 > 0) {
                    cp[cp_idx++] = (char)(d1 + 48);
                }
                cp[cp_idx++] = (char)(dig + 48);
            }
        }
        if (this._mid_dscale > 0) {
            cp[cp_idx++] = 46;
            cp_idx_end = cp_idx + this._mid_dscale;
            for (int i = 0; i < this._mid_dscale; i += 4) {
                dig = this._hasCarry ? (d >= 0 && d < this._mid_ndigits ? this._mid_digits[d] : (short)0) : (d >= 0 && d < this._mid_ndigits ? this._mid_digits[1 + d] : (short)0);
                d1 = (short)(dig / 1000);
                dig = (short)(dig - d1 * 1000);
                cp[cp_idx++] = (char)(d1 + 48);
                d1 = (short)(dig / 100);
                dig = (short)(dig - d1 * 100);
                cp[cp_idx++] = (char)(d1 + 48);
                d1 = (short)(dig / 10);
                dig = (short)(dig - d1 * 10);
                cp[cp_idx++] = (char)(d1 + 48);
                cp[cp_idx++] = (char)(dig + 48);
                ++d;
            }
            while (cp_idx < cp_idx_end) {
                cp[cp_idx++] = 48;
            }
            while (cp_idx_end < cp_idx) {
                cp[cp_idx_end] = (char)(cp[cp_idx_end] - 48);
                ++cp_idx_end;
            }
        }
        retStr = new String(cp).trim();
        return retStr;
    }

    private void _init(String value, int precision, int scale) {
        if (value == null || value == "") {
            throw new IllegalArgumentException("the string of decimal value is null or empty");
        }
        if (precision < 0 && precision != -1 || scale < 0 && scale != -1 || precision == -1 && scale != -1 || scale == -1 && precision != -1) {
            throw new IllegalArgumentException("invalid precision: " + precision + ", and scale: " + scale);
        }
        if (precision == 0 || precision > 1000 || scale > precision) {
            throw new IllegalArgumentException("invalid precision: " + precision + ", and scale: " + scale);
        }
        this._value = value;
        this._precision = precision;
        this._scale = scale;
        this._mid_typemod = precision == -1 && scale == -1 ? -1 : precision << 16 | scale;
        this._mid_ndigits = 0;
        this._mid_sign = 0;
        this._mid_dscale = 0;
        this._mid_weight = 0;
        this._mid_digits = null;
        this._size = -1;
        this._typemod = -1;
        this._signscale = 0;
        this._weight = 0;
        this._digits = null;
    }

    private void _setNan() {
        this._mid_ndigits = 0;
        this._mid_weight = 0;
        this._mid_sign = 49152;
        this._mid_dscale = 0;
    }

    private void _setMin() {
        this._mid_ndigits = 0;
        this._mid_weight = 0;
        this._mid_sign = 49152;
        this._mid_dscale = 1;
    }

    private void _setMax() {
        this._mid_ndigits = 0;
        this._mid_weight = 0;
        this._mid_sign = 49152;
        this._mid_dscale = 2;
    }

    private boolean _isMin(BSONDecimal value) {
        if (value == null) {
            return false;
        }
        return this._isSpecial(value) && value._mid_dscale == 1;
    }

    private boolean _isMax(BSONDecimal value) {
        if (value == null) {
            return false;
        }
        return this._isSpecial(value) && value._mid_dscale == 2;
    }

    private boolean _isNan(BSONDecimal value) {
        if (value == null) {
            return true;
        }
        return this._isSpecial(value) && value._mid_dscale == 0;
    }

    private boolean _isSpecial(BSONDecimal value) {
        if (value == null) {
            return true;
        }
        return value._mid_sign == 49152;
    }

    private void _alloc(int ndigits) {
        this._mid_digits = new short[ndigits + 1];
        this._mid_digits_idx = 0;
        this._mid_digits[this._mid_digits_idx++] = 0;
        this._mid_ndigits = ndigits;
    }

    private void _update() {
        this._size = 12 + this._mid_ndigits * 2;
        this._typemod = this._isSpecial(this) ? -1 : this._mid_typemod;
        this._signscale = (short)(this._mid_dscale & 0x3FFF | this._mid_sign);
        this._weight = (short)this._mid_weight;
        if (this._mid_digits == null || this._mid_digits.length == 0 || this._mid_ndigits == 0) {
            this._mid_digits = new short[0];
            this._digits = this._mid_digits;
        } else {
            this._digits = this._mid_digits;
        }
    }

    private void _strip() {
        int i;
        int ndigits;
        int digits_idx_f = 1;
        int digits_idx_e = ndigits + 1 - 1;
        for (ndigits = this._mid_ndigits; ndigits > 0 && this._mid_digits[digits_idx_f] == 0; --ndigits) {
            ++digits_idx_f;
            --this._mid_weight;
        }
        while (ndigits > 0 && this._mid_digits[digits_idx_e] == 0) {
            --digits_idx_e;
            --ndigits;
        }
        int count = digits_idx_e - digits_idx_f + 1;
        if (count != ndigits) {
            throw new IllegalStateException("ndigits[" + ndigits + "] is not equal with [" + count + "]");
        }
        if (ndigits == 0) {
            this._mid_sign = 0;
            this._mid_weight = 0;
        }
        if (digits_idx_f != 1) {
            i = digits_idx_f;
            int begin_idx = 1;
            while (i <= digits_idx_e) {
                this._mid_digits[begin_idx] = this._mid_digits[i];
                this._mid_digits[i] = 0;
                ++i;
                ++begin_idx;
            }
        }
        for (i = digits_idx_e + 1; i < this._mid_digits.length; ++i) {
            this._mid_digits[i] = 0;
        }
        this._mid_digits_idx = 1;
        this._mid_ndigits = ndigits;
    }

    private void _apply_typemod() {
        int precision = 0;
        int scale = 0;
        int maxdigits = 0;
        int ddigits = 0;
        int i = 0;
        if (this._mid_typemod == -1) {
            return;
        }
        precision = this._mid_typemod >> 16 & 0xFFFF;
        scale = this._mid_typemod & 0xFFFF;
        maxdigits = precision - scale;
        this._round(scale);
        ddigits = (this._mid_weight + 1) * 4;
        if (ddigits > maxdigits) {
            for (i = !this._hasCarry ? 1 : 0; i <= this._mid_ndigits; ++i) {
                short dig = this._mid_digits[i];
                if (dig != 0) {
                    if (dig < 10) {
                        ddigits -= 3;
                    } else if (dig < 100) {
                        ddigits -= 2;
                    } else if (dig < 1000) {
                        --ddigits;
                    }
                    if (ddigits <= maxdigits) break;
                    throw new IllegalArgumentException("the input decimal[" + this._value + "] can't be expressed in the range which is delimited by the given precision[" + precision + "] and scale[" + scale + "]");
                }
                ddigits -= 4;
            }
        }
    }

    private void _round(int rscale) {
        int di = 0;
        int ndigits = 0;
        int carry = 0;
        this._mid_dscale = rscale;
        di = (this._mid_weight + 1) * 4 + rscale;
        if (di < 0) {
            this._mid_ndigits = 0;
            this._mid_weight = 0;
            this._mid_sign = 0;
        } else {
            ndigits = (di + 4 - 1) / 4;
            if (ndigits < this._mid_ndigits || ndigits == this._mid_ndigits && (di %= 4) > 0) {
                this._mid_ndigits = ndigits--;
                if (di == 0) {
                    carry = this._mid_digits[ndigits + 1] >= 5000 ? 1 : 0;
                } else {
                    int extra = 0;
                    int pow10 = 0;
                    pow10 = round_powers[di];
                    extra = this._mid_digits[ndigits + 1] % pow10;
                    int n = ndigits + 1;
                    this._mid_digits[n] = (short)(this._mid_digits[n] - extra);
                    carry = 0;
                    if (extra >= pow10 / 2) {
                        if ((pow10 += this._mid_digits[ndigits + 1]) >= 10000) {
                            pow10 -= 10000;
                            carry = 1;
                        }
                        this._mid_digits[ndigits + 1] = (short)pow10;
                    }
                }
                while (carry != 0) {
                    if ((carry += this._mid_digits[--ndigits + 1]) >= 10000) {
                        this._mid_digits[ndigits + 1] = (short)(carry - 10000);
                        carry = 1;
                        continue;
                    }
                    this._mid_digits[ndigits + 1] = (short)carry;
                    carry = 0;
                }
                if (ndigits < 0) {
                    if (ndigits != -1) {
                        throw new IllegalStateException("ndigits[" + ndigits + "] is not -1");
                    }
                    if (this._hasCarry) {
                        throw new IllegalStateException("impossible for _hasCarry to be true");
                    }
                    if (this._mid_digits[0] == 0) {
                        throw new IllegalStateException("impossible for _digits[0] to be 0");
                    }
                    this._hasCarry = true;
                    ++this._mid_ndigits;
                    ++this._mid_weight;
                }
            }
        }
    }

    private int _getPrecision() {
        if (this._mid_typemod != -1) {
            return this._mid_typemod >> 16 & 0xFFFF;
        }
        return -1;
    }

    private int _getScale() {
        if (this._mid_typemod != -1) {
            return this._mid_typemod & 0xFFFF;
        }
        return -1;
    }

    private int _getExpectCharSize() {
        int retSize = 0;
        if (this._mid_sign == 49152 && this._mid_dscale == 0) {
            return 3;
        }
        if (this._mid_sign == 49152 && this._mid_dscale == 1) {
            return 3;
        }
        if (this._mid_sign == 49152 && this._mid_dscale == 2) {
            return 3;
        }
        retSize = (this._mid_weight + 1) * 4;
        if (retSize <= 0) {
            retSize = 1;
        }
        return retSize += this._mid_dscale + 4 + 2;
    }

    private int _compareTo(BSONDecimal other) {
        if (other == null) {
            return 1;
        }
        if (this._isMin(this)) {
            if (this._isMin(other)) {
                return 0;
            }
            return -1;
        }
        if (this._isMin(other)) {
            return 1;
        }
        if (this._isMax(this)) {
            if (this._isMax(other)) {
                return 0;
            }
            return 1;
        }
        if (this._isMax(other)) {
            return -1;
        }
        if (this._isNan(this)) {
            if (this._isNan(other)) {
                return 0;
            }
            return -1;
        }
        if (this._isNan(other)) {
            return 1;
        }
        if (this._mid_ndigits == 0) {
            if (other._mid_ndigits == 0) {
                return 0;
            }
            if (other._mid_sign == 16384) {
                return 1;
            }
            return -1;
        }
        if (other._mid_ndigits == 0) {
            if (this._mid_sign == 0) {
                return 1;
            }
            return -1;
        }
        if (this._mid_sign == 0) {
            if (other._mid_sign == 16384) {
                return 1;
            }
            return this._compareABS(other);
        }
        if (other._mid_sign == 0) {
            return -1;
        }
        return -this._compareABS(other);
    }

    private int _compareABS(BSONDecimal other) {
        int i1 = 0;
        int i2 = 0;
        int weight1 = 0;
        int ndigit1 = 0;
        short[] digits1 = null;
        int weight2 = 0;
        int ndigit2 = 0;
        short[] digits2 = null;
        if (other == null) {
            return 1;
        }
        digits1 = this.getDigits();
        digits2 = other.getDigits();
        if (digits1 == null || digits2 == null) {
            String message = "";
            message = digits1 == null ? "failed to compare for no digits in current decimal." : "failed to compare for no digits in other decimal.";
            throw new IllegalArgumentException(message);
        }
        ndigit1 = digits1.length;
        weight2 = other.getWeight();
        ndigit2 = digits2.length;
        for (weight1 = this.getWeight(); weight1 > weight2 && i1 < ndigit1; --weight1) {
            if (digits1[i1++] == 0) continue;
            return 1;
        }
        while (weight2 > weight1 && i2 < ndigit2) {
            if (digits2[i2++] != 0) {
                return -1;
            }
            --weight2;
        }
        if (weight1 == weight2) {
            while (i1 < ndigit1 && i2 < ndigit2) {
                int stat;
                if ((stat = digits1[i1++] - digits2[i2++]) == 0) continue;
                if (stat > 0) {
                    return 1;
                }
                return -1;
            }
        }
        while (i1 < ndigit1) {
            if (digits1[i1++] == 0) continue;
            return 1;
        }
        while (i2 < ndigit2) {
            if (digits2[i2++] == 0) continue;
            return -1;
        }
        return 0;
    }
}

