/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.util.StringRangeSet;

public class BasicBSONList
extends ArrayList<Object>
implements BSONObject {
    private static final long serialVersionUID = -4415279469780082174L;

    @Override
    public Object put(String key, Object v) {
        return this.put(this._getInt(key), v);
    }

    public Object put(int key, Object v) {
        while (key >= this.size()) {
            this.add(null);
        }
        this.set(key, v);
        return v;
    }

    @Override
    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAllUnique(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            if (this.containsField(entry.getKey().toString())) continue;
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    @Override
    public void putAllUnique(BSONObject o) {
        for (String k : o.keySet()) {
            if (this.containsField(k)) continue;
            this.put(k, o.get(k));
        }
    }

    @Override
    public Object get(String key) {
        int i = this._getInt(key);
        if (i < 0) {
            return null;
        }
        if (i >= this.size()) {
            return null;
        }
        return this.get(i);
    }

    @Override
    public Object removeField(String key) {
        int i = this._getInt(key);
        if (i < 0) {
            return null;
        }
        if (i >= this.size()) {
            return null;
        }
        return this.remove(i);
    }

    @Override
    @Deprecated
    public boolean containsKey(String key) {
        return this.containsField(key);
    }

    @Override
    public boolean containsField(String key) {
        int i = this._getInt(key, false);
        if (i < 0) {
            return false;
        }
        return i >= 0 && i < this.size();
    }

    @Override
    public Set<String> keySet() {
        return new StringRangeSet(this.size());
    }

    @Override
    public Map toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String s : this.keySet()) {
            m.put(s, this.get(String.valueOf(s)));
        }
        return m;
    }

    int _getInt(String s) {
        return this._getInt(s, true);
    }

    int _getInt(String s, boolean err) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            if (err) {
                throw new IllegalArgumentException("BasicBSONList can only work with numeric keys, not: [" + s + "]");
            }
            return -1;
        }
    }

    @Override
    public <T> T as(Class<T> cls) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T as(Class<T> cls, Type eleType) throws Exception {
        if (!Collection.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Current version only support as to subclass of java.util.Collection.");
        }
        AbstractCollection colletion = null;
        if (List.class.isAssignableFrom(cls)) {
            colletion = new LinkedList();
        } else if (Set.class.isAssignableFrom(cls)) {
            colletion = new TreeSet();
        } else if (Queue.class.isAssignableFrom(cls)) {
            colletion = new LinkedList();
        } else {
            throw new IllegalArgumentException("Current version not support type:" + cls.getName());
        }
        Object eleObj = null;
        for (String key : this.keySet()) {
            eleObj = this.get(key);
            if (eleObj == null) continue;
            if (BSON.IsBasicType(eleObj)) {
                colletion.add(eleObj);
                continue;
            }
            if (eleObj instanceof BasicBSONObject) {
                BSONObject comlexObj = (BSONObject)eleObj;
                colletion.add(comlexObj.as((Class)eleType));
                continue;
            }
            if (eleObj instanceof BasicBSONList) {
                Type nestedEleType = null;
                if (eleType == null || !(eleType instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Current version only support parameterized type field. unknow type=" + eleType.toString());
                }
                nestedEleType = ((ParameterizedType)eleType).getActualTypeArguments()[0];
                BSONObject comlexObj = (BSONObject)eleObj;
                colletion.add(comlexObj.as((Class)((ParameterizedType)eleType).getRawType(), nestedEleType));
                continue;
            }
            throw new IllegalArgumentException("Current version not support type:" + eleObj.getClass().getName());
        }
        return (T)colletion;
    }

    public Object asList() {
        LinkedList<Object> colletion = new LinkedList<Object>();
        for (String key : this.keySet()) {
            Object v = this.get(key);
            if (v == null) continue;
            if (BSON.IsBasicType(v)) {
                colletion.add(v);
                continue;
            }
            if (v instanceof BasicBSONList) {
                colletion.add(((BasicBSONList)v).asList());
                continue;
            }
            if (v instanceof BasicBSONObject) {
                colletion.add(((BasicBSONObject)v).asMap());
                continue;
            }
            throw new IllegalArgumentException("can't support in list. value_type=" + v.getClass());
        }
        return colletion;
    }
}

