/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bson.BSONException;

public class DateInterceptUtil {
    private static final String YMD_PRECISION_PATTERN = "yyyy-MM-dd";
    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();

    private static DateFormat getDateFormat(String pattern) {
        SimpleDateFormat format = threadLocal.get();
        if (format == null || !format.toPattern().equals(pattern)) {
            threadLocal.remove();
            format = new SimpleDateFormat(pattern);
            threadLocal.set(format);
        }
        return format;
    }

    public static Date parse(String targetStr, String pattern) throws ParseException {
        return DateInterceptUtil.getDateFormat(pattern).parse(targetStr);
    }

    public static String format(Date date, String pattern) {
        return DateInterceptUtil.getDateFormat(pattern).format(date);
    }

    public static Date interceptDate(Date date, String pattern) {
        try {
            return DateInterceptUtil.parse(DateInterceptUtil.format(date, pattern), pattern);
        }
        catch (ParseException e) {
            throw new BSONException("Intercept Date Exception: " + e.getMessage(), e);
        }
    }

    public static Long getInterceptTime(Date date, String pattern) {
        return DateInterceptUtil.interceptDate(date, pattern).getTime();
    }

    public static Long getYMDTime(Date date) {
        return DateInterceptUtil.getInterceptTime(date, YMD_PRECISION_PATTERN);
    }
}

