/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.types.BSONDecimal;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.util.JSONParseException;
import sun.misc.BASE64Decoder;

public class JSONCallback
extends BasicBSONCallback {
    private final LinkedList<Boolean> _stackIsArrayType = new LinkedList();
    public static final String _msDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String _secDateFormat = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String _dayDateFormat = "yyyy-MM-dd";
    public static final String _secTSFormat = "yyyy-MM-dd-HH.mm.ss";

    @Override
    public void objectStart(boolean array) {
        this._stackIsArrayType.addLast(array);
        super.objectStart(array);
    }

    @Override
    public void objectStart(boolean array, String name) {
        this._stackIsArrayType.addLast(array);
        super.objectStart(array, name);
    }

    @Override
    public Object objectDone() {
        String name = this.curName();
        Object o = super.objectDone();
        BSONObject b = (BSONObject)o;
        if (this._stackIsArrayType.size() <= 0) {
            throw new IllegalStateException("something is wrong in the stack of nesting object type");
        }
        Boolean isArrayType = this._stackIsArrayType.removeLast();
        if (!isArrayType.booleanValue()) {
            if (b.containsField("$oid")) {
                o = new ObjectId((String)b.get("$oid"));
                if (!this.isStackEmpty()) {
                    this.gotObjectId(name, (ObjectId)o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$numberLong")) {
                o = Long.valueOf((String)b.get("$numberLong"));
                if (!this.isStackEmpty()) {
                    this.gotLong(name, (Long)o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$date")) {
                Object dateValue = b.get("$date");
                if (dateValue instanceof Number) {
                    o = new Date(((Number)dateValue).longValue());
                } else {
                    SimpleDateFormat format = new SimpleDateFormat(_msDateFormat);
                    format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
                    o = format.parse(dateValue.toString(), new ParsePosition(0));
                    if (o == null) {
                        format = new SimpleDateFormat(_secDateFormat);
                        format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
                        o = format.parse(dateValue.toString(), new ParsePosition(0));
                    }
                    if (o == null) {
                        format = new SimpleDateFormat(_dayDateFormat);
                        o = format.parse(dateValue.toString(), new ParsePosition(0));
                    }
                }
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$timestamp")) {
                Object timeStamp = b.get("$timestamp");
                if (timeStamp instanceof String) {
                    String strTimeStamp = (String)timeStamp;
                    String dateStr = strTimeStamp.substring(0, strTimeStamp.lastIndexOf(46));
                    String incStr = strTimeStamp.substring(strTimeStamp.lastIndexOf(46) + 1);
                    SimpleDateFormat format = new SimpleDateFormat(_secTSFormat);
                    Date date = null;
                    try {
                        date = format.parse(dateStr);
                    }
                    catch (ParseException e) {
                        throw new JSONParseException(dateStr, dateStr.length() - 1, e);
                    }
                    o = new BSONTimestamp((int)(date.getTime() / 1000L), Integer.parseInt(incStr));
                    if (!this.isStackEmpty()) {
                        this.cur().put(name, o);
                    } else {
                        this.setRoot(o);
                    }
                }
            } else if (b.containsField("$decimal")) {
                Object decimal = b.get("$decimal");
                if (decimal instanceof String) {
                    String str = (String)decimal;
                    int precision = -1;
                    int scale = -1;
                    Object arr = b.get("$precision");
                    if (arr instanceof ArrayList) {
                        Object ret = ((ArrayList)arr).get(0);
                        precision = ret instanceof Integer ? (Integer)ret : Integer.parseInt((String)ret);
                        ret = ((ArrayList)arr).get(1);
                        scale = ret instanceof Integer ? (Integer)ret : Integer.parseInt((String)ret);
                    }
                    o = new BSONDecimal(str, precision, scale);
                    if (!this.isStackEmpty()) {
                        this.cur().put(name, o);
                    } else {
                        this.setRoot(o);
                    }
                }
            } else if (b.containsField("$regex")) {
                o = Pattern.compile((String)b.get("$regex"), BSON.regexFlags((String)b.get("$options")));
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$ts")) {
                Long ts = ((Number)b.get("$ts")).longValue();
                Long inc = ((Number)b.get("$inc")).longValue();
                o = new BSONTimestamp(ts.intValue(), inc.intValue());
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$minKey")) {
                o = new MinKey();
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$maxKey")) {
                o = new MaxKey();
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$uuid")) {
                o = UUID.fromString((String)b.get("$uuid"));
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$binary")) {
                String encodeString;
                byte type = 0;
                if (b.containsField("$type")) {
                    Object oType = b.get("$type");
                    if (oType instanceof Integer) {
                        Integer iType = (Integer)b.get("$type");
                        type = iType.byteValue();
                    } else {
                        String strType = (String)b.get("$type");
                        type = (byte)Integer.parseInt(strType);
                    }
                }
                if ((encodeString = (String)b.get("$binary")).length() % 4 != 0) {
                    throw new JSONParseException(encodeString, encodeString.length() - 1, "invalid size of base64 encode");
                }
                try {
                    BASE64Decoder decode = new BASE64Decoder();
                    byte[] data = decode.decodeBuffer(encodeString);
                    o = new Binary(type, data);
                    if (!this.isStackEmpty()) {
                        this.cur().put(name, o);
                    } else {
                        this.setRoot(o);
                    }
                }
                catch (IOException e) {
                    throw new JSONParseException(encodeString, encodeString.length() - 1, e);
                }
            }
        }
        return o;
    }
}

