/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONDecimal;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.bson.util.AbstractObjectSerializer;
import org.bson.util.Base64Codec;
import org.bson.util.ClassMapBasedObjectSerializer;
import org.bson.util.JSON;
import org.bson.util.ObjectSerializer;

public class JSONSerializers {
    private JSONSerializers() {
    }

    public static ObjectSerializer getLegacy() {
        ClassMapBasedObjectSerializer serializer = JSONSerializers.addCommonSerializers();
        serializer.addObjectSerializer(Date.class, new LegacyDateSerializer(serializer));
        serializer.addObjectSerializer(Timestamp.class, new LegacyBSONTimestampSerializer(serializer));
        serializer.addObjectSerializer(BSONTimestamp.class, new LegacyBSONTimestampSerializer(serializer));
        serializer.addObjectSerializer(Binary.class, new BinarySerializer(serializer));
        serializer.addObjectSerializer(byte[].class, new ByteArraySerializer(serializer));
        return serializer;
    }

    public static ObjectSerializer getStrict() {
        ClassMapBasedObjectSerializer serializer = JSONSerializers.addCommonSerializers();
        serializer.addObjectSerializer(Date.class, new DateSerializer(serializer));
        serializer.addObjectSerializer(Timestamp.class, new BSONTimestampSerializer(serializer));
        serializer.addObjectSerializer(BSONTimestamp.class, new BSONTimestampSerializer(serializer));
        serializer.addObjectSerializer(Binary.class, new BinarySerializer(serializer));
        serializer.addObjectSerializer(byte[].class, new ByteArraySerializer(serializer));
        return serializer;
    }

    static ClassMapBasedObjectSerializer addCommonSerializers() {
        ClassMapBasedObjectSerializer serializer = new ClassMapBasedObjectSerializer();
        serializer.addObjectSerializer(Object[].class, new ObjectArraySerializer(serializer));
        serializer.addObjectSerializer(Boolean.class, new ToStringSerializer());
        serializer.addObjectSerializer(Code.class, new CodeSerializer(serializer));
        serializer.addObjectSerializer(CodeWScope.class, new CodeWScopeSerializer(serializer));
        serializer.addObjectSerializer(Iterable.class, new IterableSerializer(serializer));
        serializer.addObjectSerializer(Map.class, new MapSerializer(serializer));
        serializer.addObjectSerializer(MaxKey.class, new MaxKeySerializer(serializer));
        serializer.addObjectSerializer(MinKey.class, new MinKeySerializer(serializer));
        serializer.addObjectSerializer(Number.class, new ToStringSerializer());
        serializer.addObjectSerializer(ObjectId.class, new ObjectIdSerializer(serializer));
        serializer.addObjectSerializer(Pattern.class, new PatternSerializer(serializer));
        serializer.addObjectSerializer(String.class, new StringSerializer());
        serializer.addObjectSerializer(UUID.class, new UUIDSerializer(serializer));
        serializer.addObjectSerializer(Long.class, new NumberLongSerializer(serializer));
        serializer.addObjectSerializer(BasicBSONObject.class, new BasicBSONObjectSerializer(serializer));
        serializer.addObjectSerializer(BSONDecimal.class, new BSONDecimalSerializer(serializer));
        serializer.addObjectSerializer(BigDecimal.class, new BSONDecimalSerializer(serializer));
        serializer.addObjectSerializer(Symbol.class, new SymbolSerializer(serializer));
        return serializer;
    }

    private static class SymbolSerializer
    extends CompoundObjectSerializer {
        SymbolSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            Symbol s = (Symbol)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$symbol", (Object)s.getSymbol());
            this.serializer.serialize(temp, buf);
        }
    }

    private static class ByteArraySerializer
    extends BinarySerializerBase {
        ByteArraySerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            this.serialize((byte[])obj, (byte)0, buf);
        }
    }

    private static class BinarySerializer
    extends BinarySerializerBase {
        BinarySerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            Binary bin = (Binary)obj;
            this.serialize(bin.getData(), bin.getType(), buf);
        }
    }

    private static abstract class BinarySerializerBase
    extends CompoundObjectSerializer {
        BinarySerializerBase(ObjectSerializer serializer) {
            super(serializer);
        }

        protected void serialize(byte[] bytes, byte type, StringBuilder buf) {
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$binary", (Object)new Base64Codec().encode(bytes));
            temp.put("$type", (Object)String.valueOf(type));
            this.serializer.serialize(temp, buf);
        }
    }

    private static class DateSerializer
    extends CompoundObjectSerializer {
        DateSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            Date d = (Date)obj;
            this.serializer.serialize(new BasicBSONObject("$date", d.getTime()), buf);
        }
    }

    private static class BSONDecimalSerializer
    extends CompoundObjectSerializer {
        BSONDecimalSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            BasicBSONObject temp = new BasicBSONObject();
            BSONDecimal t = null;
            t = obj instanceof BigDecimal ? new BSONDecimal((BigDecimal)obj) : (BSONDecimal)obj;
            String data = t.getValue();
            int precision = t.getPrecision();
            int scale = t.getScale();
            temp.put("$decimal", (Object)data);
            if (precision != -1 || scale != -1) {
                BasicBSONList arr = new BasicBSONList();
                arr.put("0", (Object)precision);
                arr.put("1", (Object)scale);
                temp.put("$precision", (Object)arr);
            }
            this.serializer.serialize(temp, buf);
        }
    }

    private static class BSONTimestampSerializer
    extends CompoundObjectSerializer {
        BSONTimestampSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            BSONTimestamp t = obj instanceof Timestamp ? new BSONTimestamp((Timestamp)obj) : (BSONTimestamp)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$t", (Object)t.getTime());
            temp.put("$i", (Object)t.getInc());
            BasicBSONObject timestampObj = new BasicBSONObject();
            timestampObj.put("$timestamp", (Object)temp);
            this.serializer.serialize(timestampObj, buf);
        }
    }

    private static class UUIDSerializer
    extends CompoundObjectSerializer {
        UUIDSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            UUID uuid = (UUID)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$uuid", (Object)uuid.toString());
            this.serializer.serialize(temp, buf);
        }
    }

    private static class StringSerializer
    extends AbstractObjectSerializer {
        private StringSerializer() {
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            JSON.string(buf, (String)obj);
        }
    }

    private static class PatternSerializer
    extends CompoundObjectSerializer {
        PatternSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            BasicBSONObject externalForm = new BasicBSONObject();
            externalForm.put("$regex", (Object)obj.toString());
            if (((Pattern)obj).flags() != 0) {
                externalForm.put("$options", (Object)BSON.regexFlags(((Pattern)obj).flags()));
            }
            this.serializer.serialize(externalForm, buf);
        }
    }

    private static class NumberLongSerializer
    extends CompoundObjectSerializer {
        NumberLongSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            if (!BSON.getJSCompatibility()) {
                buf.append(obj.toString());
            } else {
                Long number = (Long)obj;
                if (number >= -9007199254740991L && number <= 0x1FFFFFFFFFFFFFL) {
                    buf.append(obj.toString());
                } else {
                    this.serializer.serialize(new BasicBSONObject("$numberLong", obj.toString()), buf);
                }
            }
        }
    }

    private static class ObjectIdSerializer
    extends CompoundObjectSerializer {
        ObjectIdSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            this.serializer.serialize(new BasicBSONObject("$oid", obj.toString()), buf);
        }
    }

    private static class MinKeySerializer
    extends CompoundObjectSerializer {
        MinKeySerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            this.serializer.serialize(new BasicBSONObject("$minKey", 1), buf);
        }
    }

    private static class MaxKeySerializer
    extends CompoundObjectSerializer {
        MaxKeySerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            this.serializer.serialize(new BasicBSONObject("$maxKey", 1), buf);
        }
    }

    private static class MapSerializer
    extends CompoundObjectSerializer {
        MapSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            boolean first = true;
            buf.append("{ ");
            Map m = (Map)obj;
            Iterator iterator = m.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                if (first) {
                    first = false;
                } else {
                    buf.append(" , ");
                }
                JSON.string(buf, entry.getKey().toString());
                buf.append(" : ");
                this.serializer.serialize(entry.getValue(), buf);
            }
            buf.append(" }");
        }
    }

    private static class IterableSerializer
    extends CompoundObjectSerializer {
        IterableSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            boolean first = true;
            buf.append("[ ");
            for (Object o : (Iterable)obj) {
                if (first) {
                    first = false;
                } else {
                    buf.append(" , ");
                }
                this.serializer.serialize(o, buf);
            }
            buf.append(" ]");
        }
    }

    private static class BasicBSONObjectSerializer
    extends CompoundObjectSerializer {
        BasicBSONObjectSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            boolean first = true;
            buf.append("{ ");
            BSONObject dbo = (BSONObject)obj;
            Iterator<String> iterator = dbo.keySet().iterator();
            while (iterator.hasNext()) {
                String s;
                String name = s = iterator.next();
                if (first) {
                    first = false;
                } else {
                    buf.append(" , ");
                }
                JSON.string(buf, name);
                buf.append(" : ");
                this.serializer.serialize(dbo.get(name), buf);
            }
            buf.append(" }");
        }
    }

    private static class LegacyDateSerializer
    extends CompoundObjectSerializer {
        LegacyDateSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            Date d = (Date)obj;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.serializer.serialize(new BasicBSONObject("$date", format.format(d)), buf);
        }
    }

    private static class CodeWScopeSerializer
    extends CompoundObjectSerializer {
        CodeWScopeSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            CodeWScope c = (CodeWScope)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$code", (Object)c.getCode());
            temp.put("$scope", (Object)c.getScope());
            this.serializer.serialize(temp, buf);
        }
    }

    private static class CodeSerializer
    extends CompoundObjectSerializer {
        CodeSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            Code c = (Code)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$code", (Object)c.getCode());
            this.serializer.serialize(temp, buf);
        }
    }

    private static class LegacyBSONTimestampSerializer
    extends CompoundObjectSerializer {
        LegacyBSONTimestampSerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            BSONTimestamp t = obj instanceof Timestamp ? new BSONTimestamp((Timestamp)obj) : (BSONTimestamp)obj;
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$ts", (Object)t.getTime());
            temp.put("$inc", (Object)t.getInc());
            this.serializer.serialize(temp, buf);
        }
    }

    private static class ToStringSerializer
    extends AbstractObjectSerializer {
        private ToStringSerializer() {
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            buf.append(obj.toString());
        }
    }

    private static class ObjectArraySerializer
    extends CompoundObjectSerializer {
        ObjectArraySerializer(ObjectSerializer serializer) {
            super(serializer);
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            buf.append("[ ");
            for (int i = 0; i < Array.getLength(obj); ++i) {
                if (i > 0) {
                    buf.append(" , ");
                }
                this.serializer.serialize(Array.get(obj, i), buf);
            }
            buf.append(" ]");
        }
    }

    private static class LegacyBinarySerializer
    extends AbstractObjectSerializer {
        private LegacyBinarySerializer() {
        }

        @Override
        public void serialize(Object obj, StringBuilder buf) {
            buf.append("<Binary Data>");
        }
    }

    private static abstract class CompoundObjectSerializer
    extends AbstractObjectSerializer {
        protected final ObjectSerializer serializer;

        CompoundObjectSerializer(ObjectSerializer serializer) {
            this.serializer = serializer;
        }
    }
}

