/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.mojo;

import com.google.common.base.Stopwatch;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.Profile;
import com.squareup.wire.java.ProfileLoader;
import com.squareup.wire.schema.IdentifierSet;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.Type;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class WireGenerateSourcesMojo
extends AbstractMojo {
    @Parameter(property="wire.protoSourceDirectory", defaultValue="${project.basedir}/src/main/proto")
    private String protoSourceDirectory;
    @Parameter(property="wire.protoPaths")
    private String[] protoPaths;
    @Parameter(property="wire.android")
    private boolean emitAndroid;
    @Parameter(property="wire.compact")
    private boolean emitCompact;
    @Parameter(property="wire.includes")
    private String[] includes;
    @Parameter(property="wire.excludes")
    private String[] excludes;
    @Parameter(property="wire.serviceFactory")
    private String serviceFactory;
    @Parameter(property="wire.protoFiles", required=true)
    private String[] protoFiles;
    @Parameter(property="wire.generatedSourceDirectory", defaultValue="${project.build.directory}/generated-sources/wire")
    private String generatedSourceDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.project.addCompileSourceRoot(this.generatedSourceDirectory);
        try {
            List<String> directories = this.protoPaths != null && this.protoPaths.length > 0 ? Arrays.asList(this.protoPaths) : Collections.singletonList(this.protoSourceDirectory);
            List<String> protoFilesList = Arrays.asList(this.protoFiles);
            Schema schema = this.loadSchema(directories, protoFilesList);
            Profile profile = this.loadProfile(schema);
            IdentifierSet identifierSet = this.identifierSet();
            if (!identifierSet.isEmpty()) {
                schema = this.retainRoots(identifierSet, schema);
            }
            JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema).withAndroid(this.emitAndroid).withCompact(this.emitCompact).withProfile(profile);
            for (ProtoFile protoFile : schema.protoFiles()) {
                if (!protoFilesList.isEmpty() && !protoFilesList.contains(protoFile.location().getPath())) continue;
                for (Type type : protoFile.types()) {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    TypeSpec typeSpec = javaGenerator.generateType(type);
                    ClassName javaTypeName = javaGenerator.generatedTypeName(type);
                    this.writeJavaFile(javaTypeName, typeSpec, type.location().withPathOnly());
                    this.getLog().info((CharSequence)String.format("Generated %s in %s", javaTypeName, stopwatch));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Wire Plugin: Failure compiling proto sources.", e);
        }
    }

    private IdentifierSet identifierSet() {
        IdentifierSet.Builder identifierSetBuilder = new IdentifierSet.Builder();
        if (this.includes != null) {
            for (String identifier : this.includes) {
                identifierSetBuilder.include(identifier);
            }
        }
        if (this.excludes != null) {
            for (String identifier : this.excludes) {
                identifierSetBuilder.exclude(identifier);
            }
        }
        return identifierSetBuilder.build();
    }

    private Schema retainRoots(IdentifierSet identifierSet, Schema schema) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int oldSize = this.countTypes(schema);
        Schema prunedSchema = schema.prune(identifierSet);
        int newSize = this.countTypes(prunedSchema);
        for (String rule : identifierSet.unusedIncludes()) {
            this.getLog().warn((CharSequence)String.format("Unused include: %s", rule));
        }
        for (String rule : identifierSet.unusedExcludes()) {
            this.getLog().warn((CharSequence)String.format("Unused exclude: %s", rule));
        }
        this.getLog().info((CharSequence)String.format("Pruned schema from %s types to %s types in %s", oldSize, newSize, stopwatch));
        return prunedSchema;
    }

    private int countTypes(Schema prunedSchema) {
        int result = 0;
        for (ProtoFile protoFile : prunedSchema.protoFiles()) {
            result += protoFile.types().size();
        }
        return result;
    }

    private Schema loadSchema(List<String> directories, List<String> protos) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        SchemaLoader schemaLoader = new SchemaLoader();
        for (String directory : directories) {
            schemaLoader.addSource(new File(directory));
        }
        for (String proto : protos) {
            schemaLoader.addProto(proto);
        }
        Schema schema = schemaLoader.load();
        this.getLog().info((CharSequence)String.format("Loaded %s proto files in %s", schema.protoFiles().size(), stopwatch));
        return schema;
    }

    private Profile loadProfile(Schema schema) throws IOException {
        String profileName = this.emitAndroid ? "android" : "java";
        return new ProfileLoader(profileName).schema(schema).load();
    }

    private void writeJavaFile(ClassName javaTypeName, TypeSpec typeSpec, Location location) throws IOException {
        JavaFile.Builder builder = JavaFile.builder((String)javaTypeName.packageName(), (TypeSpec)typeSpec).addFileComment("$L", new Object[]{"Code generated by Wire protocol buffer compiler, do not edit."});
        if (location != null) {
            builder.addFileComment("\nSource file: $L", new Object[]{location});
        }
        JavaFile javaFile = builder.build();
        try {
            javaFile.writeTo(new File(this.generatedSourceDirectory));
        }
        catch (IOException e) {
            throw new IOException("Failed to write " + javaFile.packageName + "." + javaFile.typeSpec.name + " to " + this.generatedSourceDirectory, e);
        }
    }
}

