/*
 * Decompiled with CFR 0.152.
 */
package com.srm.bpmn.common.config;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

public class StringToDateConverter
implements Converter<String, Date> {
    private static final String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final String shortDateFormat = "yyyy-MM-dd";
    private static final String dateFormat2 = "yyyy/MM/dd HH:mm:ss";
    private static final String shortDateFormat2 = "yyyy/MM/dd";

    public Date convert(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        source = source.trim();
        try {
            if (source.contains("-")) {
                SimpleDateFormat formatter = source.contains(":") ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat(shortDateFormat);
                Date dtDate = formatter.parse(source);
                return dtDate;
            }
            if (source.contains("/")) {
                SimpleDateFormat formatter = source.contains(":") ? new SimpleDateFormat(dateFormat2) : new SimpleDateFormat(shortDateFormat2);
                Date dtDate = formatter.parse(source);
                return dtDate;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("parser %s to Date fail", source));
        }
        throw new RuntimeException(String.format("parser %s to Date fail", source));
    }
}

