/*
 * Decompiled with CFR 0.152.
 */
package com.srm.bpmn.common.model;

import java.io.Serializable;
import java.util.Objects;
import org.springframework.http.HttpStatus;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean success = true;
    private String message = "\u64cd\u4f5c\u6210\u529f\uff01";
    private Integer code = 0;
    private transient T result;
    private long timestamp = System.currentTimeMillis();

    public static Result<Object> ok() {
        return Result.wrapper(true, HttpStatus.OK.value(), "\u6210\u529f!", null);
    }

    public static Result<Object> ok(String msg) {
        return Result.wrapper(true, HttpStatus.OK.value(), msg, null);
    }

    public static Result<Object> ok(Object result) {
        return Result.wrapper(true, HttpStatus.OK.value(), "\u64cd\u4f5c\u6210\u529f\uff01", result);
    }

    public static Result<Object> error(String msg) {
        return Result.wrapper(false, HttpStatus.INTERNAL_SERVER_ERROR.value(), msg, null);
    }

    public static Result<Object> error(String msg, Object result) {
        return Result.wrapper(false, HttpStatus.INTERNAL_SERVER_ERROR.value(), msg, result);
    }

    public static Result<Object> error(int code, String msg) {
        return Result.wrapper(false, code, msg, null);
    }

    public static Result<Object> error(int code, String msg, Object result) {
        return Result.wrapper(false, code, msg, result);
    }

    public static Result<Object> error(HttpStatus status) {
        return Result.wrapper(false, status.value(), status.getReasonPhrase(), null);
    }

    public static Result<Object> error(Object result) {
        return Result.wrapper(false, HttpStatus.INTERNAL_SERVER_ERROR.value(), HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase(), result);
    }

    public static Result<Object> wrapper(boolean success, int code, String msg, Object result) {
        Result<Object> r = new Result<Object>();
        r.setSuccess(success);
        r.setCode(code);
        r.setMessage(msg);
        r.setResult(result);
        return r;
    }

    public static Result<Object> noAuth(String msg) {
        return Result.error(HttpStatus.NETWORK_AUTHENTICATION_REQUIRED.value(), msg);
    }

    public Result<T> success(String message) {
        this.message = message;
        this.code = HttpStatus.OK.value();
        this.success = true;
        return this;
    }

    public Result<T> fail(String message) {
        this.message = message;
        this.code = HttpStatus.INTERNAL_SERVER_ERROR.value();
        this.success = false;
        return this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getCode() {
        return this.code;
    }

    public T getResult() {
        return this.result;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Result<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public Result<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public Result<T> setCode(Integer code) {
        this.code = code;
        return this;
    }

    public Result<T> setResult(T result) {
        this.result = result;
        return this;
    }

    public Result<T> setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result1 = (Result)o;
        return this.success == result1.success && this.timestamp == result1.timestamp && Objects.equals(this.message, result1.message) && Objects.equals(this.code, result1.code) && Objects.equals(this.result, result1.result);
    }

    public int hashCode() {
        return Objects.hash(this.success, this.message, this.code, this.result, this.timestamp);
    }

    public Result<T> error500(String message) {
        this.message = message;
        this.code = 500;
        this.success = false;
        return this;
    }
}

