/*
 * Decompiled with CFR 0.152.
 */
package com.srm.bpmn.common.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.srm.bpmn.common.model.QueryOP;
import com.srm.bpmn.common.model.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class BeanUtils {
    public static <T extends Tree> List<T> listToTree(List<T> list) {
        LinkedHashMap<String, Tree> tempMap = new LinkedHashMap<String, Tree>();
        if (CollectionUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        if (!(list.get(0) instanceof Tree)) {
            throw new RuntimeException("\u6811\u5f62\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\u3002\u6570\u636e\u5fc5\u987b\u5b9e\u73b0Tree\u63a5\u53e3\uff01");
        }
        ArrayList<Tree> returnList = new ArrayList<Tree>();
        for (Tree tree : list) {
            tempMap.put(tree.getId(), tree);
        }
        for (Tree obj : list) {
            String parentId = obj.getParentId();
            if (tempMap.containsKey(parentId) && !obj.getId().equals(parentId)) {
                if (((Tree)tempMap.get(parentId)).getChildren() == null) {
                    ((Tree)tempMap.get(parentId)).setChildren(new ArrayList());
                }
                ((Tree)tempMap.get(parentId)).getChildren().add(obj);
                continue;
            }
            returnList.add(obj);
        }
        return returnList;
    }

    public static Object getValue(String columnType, QueryOP queryOP, String valStr) {
        Object value = null;
        if ("varchar".equals(columnType)) {
            value = valStr;
        } else if ("number".equals(columnType)) {
            value = Double.parseDouble(valStr);
        } else if ("date".equals(columnType)) {
            try {
                value = DateUtil.parse((CharSequence)valStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static Object getValue(String typeName, String valStr) {
        Object o = null;
        o = typeName.equals("int") ? Integer.valueOf(Integer.parseInt(valStr)) : (typeName.equals("short") ? Short.valueOf(Short.parseShort(valStr)) : (typeName.equals("long") ? Long.valueOf(Long.parseLong(valStr)) : (typeName.equals("float") ? Float.valueOf(Float.parseFloat(valStr)) : (typeName.equals("double") ? Double.valueOf(Double.parseDouble(valStr)) : (typeName.equals("boolean") ? Boolean.valueOf(Boolean.parseBoolean(valStr)) : (typeName.equals("java.lang.String") ? valStr : valStr))))));
        return o;
    }
}

