/*
 * Decompiled with CFR 0.152.
 */
package com.srm.bpmn.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static Logger logger = LoggerFactory.getLogger(DateUtils.class);
    public static ThreadLocal<SimpleDateFormat> yyyymmddhhmmss = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMddHHmmss");
        }
    };
    public static final String PARSE_EXCEPTION_8 = "ParseException";
    public static final String TIMEZONE = "GMT+8";
    public static final String FORMAT_JAVA_Y_M = "yyyy-MM";
    public static final String FORMAT_JAVA_HH_MM_SS = "HH:mm:ss";
    public static final String FORMAT_JAVA_Y_M_D = "yyyy-MM-dd";
    public static final String FORMAT_JAVA_Y_M_D_CN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String FORMAT_JAVA_Y_M_D_H = "yyyy-MM-dd HH";
    public static final String FORMAT_JAVA_Y_M_D_H_M = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_JAVA_Y_M_D_H_M_S = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_JAVA_Y_M_D_H_M_S_S = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FORMAT_JAVA_H = "HH";
    public static final String FORMAT_JAVA_H_M = "HH:mm";
    public static final String FORMAT_JAVA_H_M_S = "HH:mm:ss";
    public static final String FORMAT_ORACLE_Y_M_D = "YYYY-MM-DD";
    public static final String FORMAT_ORACLE_Y_M_D_H_M_S = "YYYY-MM-DD HH24:MI:SS";
    public static final String FORMAT_ORACLE_Y_W = "IYYY-IW";
    public static final String FORMAT_ES_Y_W = "yyyy-ww";
    public static final String PATTERN_TIME = "yyyy-MM-dd HH:mm:ss";
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    private DateUtils() {
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getGapTime(long time) {
        long hours = time / 3600000L;
        long minutes = (time - hours * 3600000L) / 60000L;
        Object diffTime = "";
        diffTime = minutes < 10L ? hours + ":0" + minutes : hours + ":" + minutes;
        return diffTime;
    }

    public static Date getStartOfDay() {
        Date date = new Date();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String date2Str(Date date, SimpleDateFormat date_sdf) {
        if (null == date) {
            return null;
        }
        return date_sdf.format(date);
    }

    public static String date2Str(SimpleDateFormat date_sdf) {
        Date date = DateUtils.getDate();
        if (null == date) {
            return null;
        }
        return date_sdf.format(date);
    }

    public static Date getDate() {
        return new Date();
    }

    public static long getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date start = calendar.getTime();
        return start.getTime();
    }

    public static Date stampToDate(long lt) {
        return new Date(lt);
    }

    public static String dateToStamp(String s) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = simpleDateFormat.parse(s);
        long ts = date.getTime();
        String res = String.valueOf(ts);
        return res;
    }

    public static Date parse(LocalDateTime localDateTime) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timer = dateTimeFormat.format(localDateTime);
        try {
            return DateUtils.parse(timer);
        }
        catch (ParseException e) {
            logger.info(PARSE_EXCEPTION_8, (Throwable)e);
            return null;
        }
    }

    public static Date parse(String source) throws ParseException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (source.length() <= dateTimeFormat.toPattern().length() && source.length() >= dateTimeFormat.toPattern().length() - 5) {
            try {
                return dateTimeFormat.parse(source);
            }
            catch (ParseException ex) {
                logger.info(PARSE_EXCEPTION_8, (Throwable)ex);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_JAVA_Y_M_D);
        if (source.length() <= dateFormat.toPattern().length() && source.length() >= dateFormat.toPattern().length() - 2) {
            try {
                return dateFormat.parse(source);
            }
            catch (ParseException ex) {
                logger.info(PARSE_EXCEPTION_8, (Throwable)ex);
            }
        }
        SimpleDateFormat monthFormat = new SimpleDateFormat(FORMAT_JAVA_Y_M);
        if (source.length() <= monthFormat.toPattern().length() && source.length() >= monthFormat.toPattern().length() - 1) {
            try {
                return monthFormat.parse(source);
            }
            catch (ParseException ex) {
                logger.info(PARSE_EXCEPTION_8, (Throwable)ex);
            }
        }
        return dateTimeFormat.parse(source);
    }

    public static Date parseDate(String source) throws ParseException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_JAVA_Y_M_D);
        return dateFormat.parse(source);
    }

    public static Date parseDate(String source, String dateFormat) throws ParseException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat dateFormat2 = new SimpleDateFormat(dateFormat);
        return dateFormat2.parse(source);
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDate(date, null);
    }

    public static String formatDate(Date date, String defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_JAVA_Y_M_D);
        return dateFormat.format(date);
    }

    public static Date getCurrentDate() {
        ZonedDateTime zdt = ZonedDateTime.now();
        DateTimeFormatter dateTimeFormater = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String format = dateTimeFormater.format(zdt);
        try {
            return DateUtils.parseDateTime(format);
        }
        catch (ParseException e) {
            logger.info(PARSE_EXCEPTION_8, (Throwable)e);
            return null;
        }
    }

    public static String getCurrent() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(new Date());
    }

    public static String getCurrentYMd() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_JAVA_Y_M_D);
        return df.format(new Date());
    }

    public static Date parseDateTimeYMd(String source) throws ParseException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(FORMAT_JAVA_Y_M_D);
        return dateTimeFormat.parse(source);
    }

    public static Date parseDateTime(String source) throws ParseException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateTimeFormat.parse(source);
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDateTime(date, null);
    }

    public static String formatDateTime(Date date, String defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateTimeFormat.format(date);
    }

    public static Date parseMonth(String source) throws ParseException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat monthFormat = new SimpleDateFormat(FORMAT_JAVA_Y_M);
        return monthFormat.parse(source);
    }

    public static String formatMonth(Date date) {
        return DateUtils.formatMonth(date, null);
    }

    public static String formatMonth(Date date, String defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        SimpleDateFormat monthFormat = new SimpleDateFormat(FORMAT_JAVA_Y_M);
        return monthFormat.format(date);
    }

    public static String calcTimeStr(Date startDate, Date endDate) {
        long between = endDate.getTime() - startDate.getTime();
        long day = between / 86400000L;
        long hour = between / 3600000L - day * 24L;
        long min = between / 60000L - day * 24L * 60L - hour * 60L;
        long s = between / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206" + s + "\u79d2";
    }

    public static String timeStamp2Date(String seconds, String format) {
        if (seconds == null || seconds.isEmpty() || "null".equals(seconds)) {
            return "";
        }
        if (format == null || format.isEmpty()) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(Long.valueOf(seconds + "000")));
    }

    public static String timeStamp(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(Long.parseLong(String.valueOf(time))));
    }

    public static int getYear() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        return year;
    }

    public static int getMonth() {
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2) + 1;
        return month;
    }
}

