/*
 * Decompiled with CFR 0.152.
 */
package com.srm.bpmn.common.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
    private Properties props;
    private String fileName;

    public PropertiesUtil(String fileName) {
        this.fileName = fileName;
        this.readProperties(fileName);
    }

    private void readProperties(String fileName) {
        try {
            this.props = new Properties();
            this.props.load(PropertiesUtil.class.getResourceAsStream("/" + fileName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public Map<String, String> getAllProperty() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> enu = this.props.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = this.props.getProperty(key);
            map.put(key, value);
        }
        return map;
    }

    public void printProperties() {
        this.props.list(System.out);
    }

    public void writeProperties(String key, String value) {
        try {
            FileOutputStream fos = new FileOutputStream(this.fileName);
            this.props.setProperty(key, value);
            this.props.store(fos, "\u300ecomments\u300fUpdate key\uff1a" + key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

