/*
 * Decompiled with CFR 0.152.
 */
package com.srm.bpmn.common.utils;

import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.stereotype.Component;

@Component
public class SpringPropertyResourceReader
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static Properties properties;
    private static PropertySourcesPropertyResolver propertySourcesPropertyResolver;

    private static void init() {
        try {
            Environment env = applicationContext.getEnvironment();
            StandardEnvironment standardServletEnvironment = (StandardEnvironment)env;
            MutablePropertySources mutablePropertySources = standardServletEnvironment.getPropertySources();
            for (PropertySource propertySource : mutablePropertySources) {
                Object source = propertySource.getSource();
                if (!(source instanceof Properties)) continue;
                Properties prop = (Properties)propertySource.getSource();
                properties.putAll((Map<?, ?>)prop);
            }
            propertySourcesPropertyResolver = new PropertySourcesPropertyResolver((PropertySources)standardServletEnvironment.getPropertySources());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPropertyRaw(String propertyName) {
        return properties.getProperty(propertyName);
    }

    public static String getProperty(String key) {
        return propertySourcesPropertyResolver.getProperty(key);
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        applicationContext = arg0;
        SpringPropertyResourceReader.init();
    }

    static {
        properties = new Properties();
        propertySourcesPropertyResolver = null;
    }
}

