/*
 * Decompiled with CFR 0.152.
 */
package com.srm.bpmn.common.utils;

import com.srm.bpmn.common.utils.Exp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class Templ {
    private List<Exp> exps = new ArrayList<Exp>();

    Templ() {
    }

    static Templ of(String templStr) {
        Objects.requireNonNull(templStr, "\u6a21\u677f\u4e3a\u7a7a");
        Templ templ = new Templ();
        StringBuilder sb = new StringBuilder();
        char[] chars = templStr.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '#': 
                case '$': {
                    if (i < chars.length - 1 && chars[i + 1] == '{') {
                        templ.addExp(Exp.of(sb.toString()));
                        sb.setLength(0);
                    }
                    sb.append(chars[i]);
                    continue block4;
                }
                case '}': {
                    sb.append('}');
                    if (sb.length() <= 1 || sb.charAt(1) != '{') continue block4;
                    templ.addExp(Exp.of(sb.toString()));
                    sb.setLength(0);
                    continue block4;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        if (sb.length() > 0) {
            templ.addExp(Exp.of(sb.toString()));
        }
        return templ;
    }

    private Templ addExp(Exp exp) {
        Objects.requireNonNull(exp, "\u8868\u8fbe\u5f0f\u4e3a\u7a7a");
        this.exps.add(exp);
        return this;
    }

    String render(Map<String, String> context) {
        StringBuilder sb = new StringBuilder();
        for (Exp exp : this.exps) {
            sb.append(exp.resolve(context));
        }
        return sb.toString();
    }
}

