/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.method;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.server.impl.application.ResourceMethodDispatcherFactory;
import com.sun.jersey.server.impl.container.filter.FilterFactory;
import com.sun.jersey.server.impl.model.method.ResourceMethod;
import com.sun.jersey.spi.container.ResourceFilter;
import java.lang.reflect.Method;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceHttpMethod
extends ResourceMethod {
    private final Method m;

    public ResourceHttpMethod(ResourceMethodDispatcherFactory df, FilterFactory ff, AbstractResourceMethod method) {
        this(df, ff, UriTemplate.EMPTY, method);
    }

    public ResourceHttpMethod(ResourceMethodDispatcherFactory df, FilterFactory ff, UriTemplate template, AbstractResourceMethod method) {
        this(df, ff, ff.getResourceFilters(method), template, method);
    }

    public ResourceHttpMethod(ResourceMethodDispatcherFactory df, FilterFactory ff, List<ResourceFilter> resourceFilters, UriTemplate template, AbstractResourceMethod method) {
        super(method.getHttpMethod(), template, method.getSupportedInputTypes(), method.getSupportedOutputTypes(), method.areInputTypesDeclared(), df.getDispatcher(method), FilterFactory.getRequestFilters(resourceFilters), FilterFactory.getResponseFilters(resourceFilters));
        this.m = method.getMethod();
        if (this.getDispatcher() == null) {
            String msg = ImplMessages.NOT_VALID_HTTPMETHOD(this.m, method.getHttpMethod(), this.m.getDeclaringClass());
            throw new ContainerException(msg);
        }
    }

    public String toString() {
        return ImplMessages.RESOURCE_METHOD(this.m.getDeclaringClass(), this.m.getName());
    }
}

