/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.xml.ws.util.UtilException;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public final class MessageWriter
extends FilterWriter {
    private boolean filtering = false;
    private boolean notPrinted = true;
    private boolean headers = false;
    private int size = 0;
    private int limit;

    public MessageWriter(Writer out, int limit) {
        super(out);
        this.limit = limit;
    }

    public void println(Object o) throws IOException {
        this.write(o.toString());
    }

    public void println(String str) throws IOException {
        this.write(str);
    }

    public void println() throws IOException {
        this.write("\n");
    }

    @Override
    public void write(String str) throws IOException {
        if (!this.headers && str.startsWith("--")) {
            this.headers = true;
            this.filtering = false;
            this.notPrinted = true;
        }
        if (this.headers) {
            if (str.contains("Content-Type: ")) {
                String ct = str.toLowerCase();
                if (ct.contains("image/") || ct.contains("/octet-stream") || ct.contains("fastinfoset")) {
                    this.filtering = true;
                }
            } else if (str.toLowerCase().contains("content-transfer-encoding: binary")) {
                this.filtering = true;
            }
            if (str.isBlank()) {
                this.headers = false;
            }
        }
        if (!this.headers && this.filtering) {
            if (this.notPrinted) {
                this.notPrinted = false;
                super.write("\n...binary data...");
                super.write("\n");
                this.size += 18;
            }
        } else {
            if (this.size + str.length() >= this.limit) {
                super.write(str.substring(0, this.limit - this.size));
                super.write("\n");
                throw new UtilException(new IOException("large input"));
            }
            this.size += str.length();
            super.write(str);
            super.write("\n");
        }
        this.flush();
    }
}

