/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.base;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.metadata.AnnotatedElementUtilsPlus;
import com.baomidou.mybatisplus.core.metadata.impl.TableFieldImpl;
import com.tangzc.mpe.annotation.DefaultValue;
import com.tangzc.mpe.annotation.OptionDate;
import com.tangzc.mpe.annotation.OptionUser;
import com.tangzc.mpe.annotation.handler.AutoFillHandler;
import com.tangzc.mpe.base.util.SpringContextUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class AutoFillMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoFillMetaObjectHandler.class);

    public void insertFill(MetaObject metaObject) {
        this.optionFill(metaObject, FieldFill.INSERT);
    }

    public void updateFill(MetaObject metaObject) {
        this.optionFill(metaObject, FieldFill.UPDATE);
    }

    private void optionFill(MetaObject metaObject, FieldFill option) {
        Object object = metaObject.getOriginalObject();
        Class<?> clazz = object.getClass();
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(declaredFields));
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            declaredFields = superClass.getDeclaredFields();
            fields.addAll(Arrays.asList(declaredFields));
        }
        List<Field> fieldList = fields.stream().filter(field -> metaObject.hasSetter(field.getName())).filter(field -> {
            TableField annotation = (TableField)AnnotatedElementUtilsPlus.findMergedAnnotation((AnnotatedElement)field, TableField.class, TableFieldImpl.class);
            return annotation != null && (annotation.fill() == option || annotation.fill() == FieldFill.INSERT_UPDATE);
        }).collect(Collectors.toList());
        this.fill(metaObject, object, clazz, fieldList);
    }

    public void fill(MetaObject metaObject, Object object, Class<?> clazz, List<Field> fieldList) {
        Now now = new Now();
        fieldList.forEach(field -> {
            this.setDefaultVale(metaObject, (Field)field);
            this.setOptionUser(metaObject, object, clazz, (Field)field);
            this.setOptionDate(metaObject, clazz, (Field)field, now);
        });
    }

    private void setDefaultVale(MetaObject metaObject, Field field) {
        DefaultValue defaultValue = (DefaultValue)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, DefaultValue.class);
        if (defaultValue != null) {
            boolean canSet;
            boolean bl = canSet = this.getFieldValByName(field.getName(), metaObject) == null;
            if (canSet) {
                Object newVal = this.convert(field, defaultValue);
                this.setFieldValByName(field.getName(), newVal, metaObject);
            }
        }
    }

    private void setOptionUser(MetaObject metaObject, Object object, Class<?> clazz, Field field) {
        OptionUser optionUser = (OptionUser)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, OptionUser.class);
        if (optionUser != null) {
            boolean canSet;
            boolean bl = canSet = this.getFieldValByName(field.getName(), metaObject) == null || optionUser.override();
            if (canSet) {
                Object userInfo = null;
                AutoFillHandler instance = this.getAutoFillHandler(optionUser.value());
                if (instance != null) {
                    userInfo = instance.getVal(object, clazz, field);
                }
                if (userInfo != null) {
                    this.setFieldValByName(field.getName(), userInfo, metaObject);
                }
            }
        }
    }

    private AutoFillHandler getAutoFillHandler(Class<? extends AutoFillHandler> autoFillHandler) {
        try {
            return (AutoFillHandler)SpringContextUtil.getApplicationContext().getBean(autoFillHandler);
        }
        catch (NoUniqueBeanDefinitionException ignore) {
            throw new RuntimeException("\u53d1\u73b0\u4e86\u591a\u4e2a" + autoFillHandler.getName() + "\u7684\u5b9e\u73b0\uff0c\u8bf7\u4fdd\u6301spring\u4e2d\u53ea\u6709\u4e00\u4e2a\u5b9e\u4f8b\u3002");
        }
        catch (NoSuchBeanDefinitionException ignore) {
            if (autoFillHandler.isInterface()) {
                log.warn("\u6ca1\u6709\u627e\u5230{}\u7684\u5b9e\u73b0\uff0c\u64cd\u4f5c\u4eba\u4fe1\u606f\u65e0\u6cd5\u81ea\u52a8\u586b\u5145\u3002", (Object)autoFillHandler.getName());
            } else {
                log.warn("{}\u9700\u8981\u6ce8\u518c\u5230spring\uff0c\u4e0d\u7136\u64cd\u4f5c\u4eba\u4fe1\u606f\u65e0\u6cd5\u81ea\u52a8\u586b\u5145\u3002", (Object)autoFillHandler.getName());
            }
            return null;
        }
    }

    private void setOptionDate(MetaObject metaObject, Class<?> clazz, Field field, Now now) {
        OptionDate optionDate = (OptionDate)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, OptionDate.class);
        if (optionDate != null) {
            boolean canSet;
            boolean bl = canSet = this.getFieldValByName(field.getName(), metaObject) == null || optionDate.override();
            if (canSet) {
                Class<?> type = this.getDateType(clazz, field);
                Object nowDate = Optional.ofNullable(now.now(type, optionDate.format())).orElseThrow(() -> new RuntimeException("\u7c7b\uff1a" + clazz.toString() + "\u7684\u5b57\u6bb5\uff1a" + field.getName() + "\u7684\u7c7b\u578b\u4e0d\u652f\u6301\u3002\u4ec5\u652f\u6301String\u3001Long\u3001long\u3001Date\u3001LocalDate\u3001LocalDateTime"));
                this.setFieldValByName(field.getName(), nowDate, metaObject);
            }
        }
    }

    private Class<?> getDateType(Class<?> clazz, Field field) {
        List<FieldDateTypeHandler> fieldTypeHandlers = SpringContextUtil.getBeansOfTypeList(FieldDateTypeHandler.class);
        Class<?> type = fieldTypeHandlers.stream().map(handler -> handler.getDateType(clazz, field)).filter(Objects::nonNull).findFirst().orElse(null);
        if (type == null) {
            type = field.getType();
        }
        return type;
    }

    private Object convert(Field field, DefaultValue defaultValue) {
        String value = defaultValue.value();
        final String format = defaultValue.format();
        Class<?> type = field.getType();
        HashMap convertFuncMap = new HashMap<Class<?>, Function<String, Object>>(16){
            {
                super(x0);
                this.put(String.class, value -> value);
                this.put(Long.class, Long::parseLong);
                this.put(Long.TYPE, Long::parseLong);
                this.put(Integer.class, Integer::parseInt);
                this.put(Integer.TYPE, Integer::parseInt);
                this.put(Boolean.class, Boolean::parseBoolean);
                this.put(Boolean.TYPE, Boolean::parseBoolean);
                this.put(Double.class, Double::parseDouble);
                this.put(Double.TYPE, Double::parseDouble);
                this.put(Float.class, Float::parseFloat);
                this.put(Float.TYPE, Float::parseFloat);
                this.put(BigDecimal.class, BigDecimal::new);
                this.put(Date.class, value -> {
                    try {
                        return new SimpleDateFormat(format).parse((String)value);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("\u65e5\u671f\u683c\u5f0f" + format + "\u4e0e\u503c" + value + "\u4e0d\u5339\u914d\uff01");
                    }
                });
                this.put(LocalDate.class, value -> {
                    try {
                        return LocalDate.parse(value, DateTimeFormatter.ofPattern(format));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u65e5\u671f\u683c\u5f0f" + format + "\u4e0e\u503c" + value + "\u4e0d\u5339\u914d\uff01");
                    }
                });
                this.put(LocalDateTime.class, value -> {
                    try {
                        return LocalDateTime.parse(value, DateTimeFormatter.ofPattern(format));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u65e5\u671f\u683c\u5f0f" + format + "\u4e0e\u503c" + value + "\u4e0d\u5339\u914d\uff01");
                    }
                });
            }
        };
        Function<String, Object> convertFunc = convertFuncMap.getOrDefault(type, val -> {
            if (type.isEnum()) {
                T[] enumConstants = type.getEnumConstants();
                if (enumConstants.length > 0) {
                    for (Object enumConstant : enumConstants) {
                        if (!Objects.equals(val, enumConstant.toString())) continue;
                        return enumConstant;
                    }
                }
                throw new RuntimeException("\u9ed8\u8ba4\u503c" + val + "\u4e0e\u679a\u4e3e" + type.getName() + "\u4e0d\u5339\u914d\uff01");
            }
            return val;
        });
        return convertFunc.apply(value);
    }

    @FunctionalInterface
    public static interface FieldDateTypeHandler {
        public Class<?> getDateType(Class<?> var1, Field var2);
    }

    private static class Now {
        private final LocalDateTime localDateTime = LocalDateTime.now();
        private final LocalDate localDate = this.localDateTime.toLocalDate();
        private final Date date = Date.from(this.localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        private final Long timestamp = this.date.getTime();

        private Now() {
        }

        public Object now(Class<?> type, String format) {
            if (type == String.class) {
                return this.localDateTime.format(DateTimeFormatter.ofPattern(format));
            }
            if (type == Long.TYPE || type == Long.class) {
                return this.timestamp;
            }
            if (type == Date.class) {
                return this.date;
            }
            if (type == LocalDate.class) {
                return this.localDate;
            }
            if (type == LocalDateTime.class) {
                return this.localDateTime;
            }
            return null;
        }
    }
}

