/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.common.TDBlob;
import com.taosdata.jdbc.utils.DataTypeConverUtil;
import com.taosdata.jdbc.utils.DateTimeUtils;
import com.taosdata.jdbc.utils.UnsignedDataUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class TSDBResultSetBlockData {
    private int numOfRows = 0;
    private int rowIndex = 0;
    private List<ColumnMetaData> columnMetaDataList;
    private ArrayList<List<Object>> colData;
    public boolean wasNull;
    private int timestampPrecision;
    private ByteBuffer buffer;
    Semaphore semaphore = new Semaphore(0);
    public int returnCode = 0;

    public TSDBResultSetBlockData(List<ColumnMetaData> colMeta, int numOfCols, int timestampPrecision) {
        this.columnMetaDataList = colMeta;
        this.colData = new ArrayList(numOfCols);
        this.timestampPrecision = timestampPrecision;
    }

    public TSDBResultSetBlockData(List<ColumnMetaData> colMeta, int timestampPrecision) {
        this.columnMetaDataList = colMeta;
        this.colData = new ArrayList();
        this.timestampPrecision = timestampPrecision;
    }

    public TSDBResultSetBlockData() {
        this.colData = new ArrayList();
    }

    public void clear() {
        int size = this.colData.size();
        this.colData.clear();
        this.setNumOfCols(size);
    }

    public int getNumOfRows() {
        return this.numOfRows;
    }

    public void setNumOfRows(int numOfRows) {
        this.numOfRows = numOfRows;
    }

    public int getNumOfCols() {
        return this.colData.size();
    }

    public void setNumOfCols(int numOfCols) {
        this.colData = new ArrayList(numOfCols);
    }

    public boolean hasMore() {
        return this.rowIndex < this.numOfRows;
    }

    public boolean forward() {
        if (this.rowIndex > this.numOfRows) {
            return false;
        }
        return ++this.rowIndex < this.numOfRows;
    }

    public void reset() {
        this.rowIndex = 0;
    }

    public void setByteArray(byte[] value) {
        byte[] copy = new byte[value.length];
        System.arraycopy(value, 0, copy, 0, value.length);
        this.buffer = ByteBuffer.wrap(copy);
    }

    public void doSetByteArray() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int bitMapOffset = this.BitmapLen(this.numOfRows);
        int pHeader = 28 + this.columnMetaDataList.size() * 5;
        this.buffer.position(pHeader);
        ArrayList<Integer> lengths = new ArrayList<Integer>(this.columnMetaDataList.size());
        for (int i = 0; i < this.columnMetaDataList.size(); ++i) {
            lengths.add(this.buffer.getInt());
        }
        pHeader = this.buffer.position();
        int length = 0;
        for (int i = 0; i < this.columnMetaDataList.size(); ++i) {
            ArrayList<Object> col = new ArrayList<Object>(this.numOfRows);
            int type = this.columnMetaDataList.get(i).getColType();
            switch (type) {
                case 1: 
                case 2: 
                case 11: {
                    int j;
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        byte b = this.buffer.get();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(b);
                    }
                    break;
                }
                case 3: 
                case 12: {
                    int j;
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        short s = this.buffer.getShort();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(s);
                    }
                    break;
                }
                case 4: 
                case 13: {
                    int j;
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        int in = this.buffer.getInt();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(in);
                    }
                    break;
                }
                case 5: 
                case 14: {
                    int j;
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        long l = this.buffer.getLong();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(l);
                    }
                    break;
                }
                case 9: {
                    int j;
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        long l = this.buffer.getLong();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(DateTimeUtils.parseTimestampColumnData(l, this.timestampPrecision));
                    }
                    break;
                }
                case 6: {
                    int j;
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        float f = this.buffer.getFloat();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(Float.valueOf(f));
                    }
                    break;
                }
                case 7: {
                    int j;
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        double d = this.buffer.getDouble();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(d);
                    }
                    break;
                }
                case 8: 
                case 15: 
                case 16: 
                case 18: 
                case 20: {
                    Object[] tmp;
                    int len;
                    int m;
                    int m2;
                    length = this.numOfRows * 4;
                    ArrayList<Integer> offset = new ArrayList<Integer>(this.numOfRows);
                    for (m2 = 0; m2 < this.numOfRows; ++m2) {
                        offset.add(this.buffer.getInt());
                    }
                    int start = this.buffer.position();
                    for (m = 0; m < this.numOfRows; ++m) {
                        if (-1 == (Integer)offset.get(m)) {
                            col.add(null);
                            continue;
                        }
                        this.buffer.position(start + (Integer)offset.get(m));
                        len = type != 18 ? this.buffer.getShort() & 0xFFFF : this.buffer.getInt();
                        tmp = new byte[len];
                        this.buffer.get((byte[])tmp);
                        col.add(tmp);
                    }
                    break;
                }
                case 10: {
                    Object[] tmp;
                    int len;
                    int m;
                    int m2;
                    length = this.numOfRows * 4;
                    ArrayList<Integer> offset = new ArrayList(this.numOfRows);
                    for (m2 = 0; m2 < this.numOfRows; ++m2) {
                        offset.add(this.buffer.getInt());
                    }
                    int start = this.buffer.position();
                    for (m = 0; m < this.numOfRows; ++m) {
                        if (-1 == (Integer)offset.get(m)) {
                            col.add(null);
                            continue;
                        }
                        this.buffer.position(start + (Integer)offset.get(m));
                        len = (this.buffer.getShort() & 0xFFFF) / 4;
                        tmp = new int[len];
                        for (int n = 0; n < len; ++n) {
                            tmp[n] = this.buffer.getInt();
                        }
                        col.add(new String((int[])tmp, 0, tmp.length));
                    }
                    break;
                }
                default: {
                    col.add(null);
                }
            }
            this.buffer.position(pHeader += length + (Integer)lengths.get(i));
            this.colData.add(col);
        }
        this.semaphore.release();
    }

    public void doneWithNoData() {
        this.semaphore.release();
    }

    public void waitTillOK() throws SQLException {
        try {
            if (!this.semaphore.tryAcquire(5L, TimeUnit.SECONDS)) {
                throw TSDBError.createSQLException(9040, "FETCH DATA TIME OUT");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public String getString(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return DataTypeConverUtil.getString(obj);
    }

    public byte[] getBytes(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return DataTypeConverUtil.getBytes(obj);
    }

    public int getInt(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        int type = this.columnMetaDataList.get(col).getColType();
        return DataTypeConverUtil.getInt(type, obj, col);
    }

    public boolean getBoolean(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return Boolean.FALSE;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        this.wasNull = false;
        int type = this.columnMetaDataList.get(col).getColType();
        return DataTypeConverUtil.getBoolean(type, obj);
    }

    public long getLong(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return 0L;
        }
        this.wasNull = false;
        if (obj instanceof Long) {
            return (Long)obj;
        }
        int type = this.columnMetaDataList.get(col).getColType();
        return DataTypeConverUtil.getLong(type, obj, col, this.timestampPrecision);
    }

    private void throwRangeException(String valueAsString, int columnIndex, int jdbcType) throws SQLException {
        throw TSDBError.createSQLException(8980, "'" + valueAsString + "' in column '" + columnIndex + "' is outside valid range for the jdbcType " + TSDBConstants.jdbcType2TaosTypeName(jdbcType));
    }

    public Timestamp getTimestamp(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        int type = this.columnMetaDataList.get(col).getColType();
        if (type == 5) {
            Instant instant = DateTimeUtils.parseTimestampColumnData((Long)obj, this.timestampPrecision);
            return DateTimeUtils.getTimestamp(instant, null);
        }
        if (type == 9) {
            return DateTimeUtils.getTimestamp((Instant)obj, null);
        }
        if (obj instanceof byte[]) {
            String tmp = "";
            String charset = TaosGlobalConfig.getCharset();
            try {
                tmp = new String((byte[])obj, charset);
                return DateTimeUtils.parseTimestamp(tmp, null);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return new Timestamp(this.getLong(col));
    }

    public double getDouble(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return 0.0;
        }
        this.wasNull = false;
        int type = this.columnMetaDataList.get(col).getColType();
        return DataTypeConverUtil.getDouble(type, obj, col, this.timestampPrecision);
    }

    public Object get(int col) {
        List<Object> bb = this.colData.get(col);
        Object source = bb.get(this.rowIndex);
        if (null == source) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        switch (this.columnMetaDataList.get(col).getColType()) {
            case 1: {
                byte val = (Byte)source;
                return val == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 20: {
                return source;
            }
            case 18: {
                return new TDBlob((byte[])source, true);
            }
            case 11: {
                byte val = (Byte)source;
                return UnsignedDataUtils.parseUTinyInt(val);
            }
            case 12: {
                short val = (Short)source;
                return UnsignedDataUtils.parseUSmallInt(val);
            }
            case 13: {
                int val = (Integer)source;
                return UnsignedDataUtils.parseUInteger(val);
            }
            case 14: {
                long val = (Long)source;
                return UnsignedDataUtils.parseUBigInt(val);
            }
        }
        return null;
    }

    private int BitmapLen(int n) {
        return n + 7 >> 3;
    }

    private boolean isNull(byte[] c, int n) {
        int position = n >>> 3;
        int index = n & 7;
        return (c[position] & 1 << 7 - index) == 1 << 7 - index;
    }
}

