/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.FilteringStruct;
import com.tencent.ads.model.ProductItemsAddRequest;
import com.tencent.ads.model.ProductItemsAddResponse;
import com.tencent.ads.model.ProductItemsGetResponse;
import com.tencent.ads.model.ProductItemsUpdateRequest;
import com.tencent.ads.model.ProductItemsUpdateResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProductItemsApi {
    private ApiClient apiClient;

    public ProductItemsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductItemsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call productItemsAddCall(ProductItemsAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ProductItemsAddRequest localVarPostBody = data;
        String localVarPath = "/product_items/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call productItemsAddValidateBeforeCall(ProductItemsAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling productItemsAdd(Async)");
        }
        Call call = this.productItemsAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    public ProductItemsAddResponse productItemsAdd(ProductItemsAddRequest data) throws ApiException {
        ApiResponse<ProductItemsAddResponse> resp = this.productItemsAddWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<ProductItemsAddResponse> productItemsAddWithHttpInfo(ProductItemsAddRequest data) throws ApiException {
        Call call = this.productItemsAddValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<ProductItemsAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call productItemsAddAsync(ProductItemsAddRequest data, final ApiCallback<ProductItemsAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.productItemsAddValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProductItemsAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call productItemsGetCall(Long accountId, Long productCatalogId, List<FilteringStruct> filtering, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/product_items/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (productCatalogId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("product_catalog_id", productCatalogId));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call productItemsGetValidateBeforeCall(Long accountId, Long productCatalogId, List<FilteringStruct> filtering, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling productItemsGet(Async)");
        }
        if (productCatalogId == null) {
            throw new ApiException("Missing the required parameter 'productCatalogId' when calling productItemsGet(Async)");
        }
        Call call = this.productItemsGetCall(accountId, productCatalogId, filtering, fields, progressListener, progressRequestListener);
        return call;
    }

    public ProductItemsGetResponse productItemsGet(Long accountId, Long productCatalogId, List<FilteringStruct> filtering, List<String> fields) throws ApiException {
        ApiResponse<ProductItemsGetResponse> resp = this.productItemsGetWithHttpInfo(accountId, productCatalogId, filtering, fields);
        return resp.getData();
    }

    public ApiResponse<ProductItemsGetResponse> productItemsGetWithHttpInfo(Long accountId, Long productCatalogId, List<FilteringStruct> filtering, List<String> fields) throws ApiException {
        Call call = this.productItemsGetValidateBeforeCall(accountId, productCatalogId, filtering, fields, null, null);
        Type localVarReturnType = new TypeToken<ProductItemsGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call productItemsGetAsync(Long accountId, Long productCatalogId, List<FilteringStruct> filtering, List<String> fields, final ApiCallback<ProductItemsGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.productItemsGetValidateBeforeCall(accountId, productCatalogId, filtering, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProductItemsGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call productItemsUpdateCall(ProductItemsUpdateRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ProductItemsUpdateRequest localVarPostBody = data;
        String localVarPath = "/product_items/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call productItemsUpdateValidateBeforeCall(ProductItemsUpdateRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling productItemsUpdate(Async)");
        }
        Call call = this.productItemsUpdateCall(data, progressListener, progressRequestListener);
        return call;
    }

    public ProductItemsUpdateResponse productItemsUpdate(ProductItemsUpdateRequest data) throws ApiException {
        ApiResponse<ProductItemsUpdateResponse> resp = this.productItemsUpdateWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<ProductItemsUpdateResponse> productItemsUpdateWithHttpInfo(ProductItemsUpdateRequest data) throws ApiException {
        Call call = this.productItemsUpdateValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<ProductItemsUpdateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call productItemsUpdateAsync(ProductItemsUpdateRequest data, final ApiCallback<ProductItemsUpdateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.productItemsUpdateValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProductItemsUpdateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

