/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.ProductSeriesGetResponse;
import com.tencent.ads.model.ProductSeriesSearchFilteringStruct;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProductSeriesApi {
    private ApiClient apiClient;

    public ProductSeriesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductSeriesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call productSeriesGetCall(Long accountId, Long catalogId, List<ProductSeriesSearchFilteringStruct> filtering, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/product_series/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (catalogId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("catalog_id", catalogId));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call productSeriesGetValidateBeforeCall(Long accountId, Long catalogId, List<ProductSeriesSearchFilteringStruct> filtering, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling productSeriesGet(Async)");
        }
        if (catalogId == null) {
            throw new ApiException("Missing the required parameter 'catalogId' when calling productSeriesGet(Async)");
        }
        Call call = this.productSeriesGetCall(accountId, catalogId, filtering, page, pageSize, fields, progressListener, progressRequestListener);
        return call;
    }

    public ProductSeriesGetResponse productSeriesGet(Long accountId, Long catalogId, List<ProductSeriesSearchFilteringStruct> filtering, Long page, Long pageSize, List<String> fields) throws ApiException {
        ApiResponse<ProductSeriesGetResponse> resp = this.productSeriesGetWithHttpInfo(accountId, catalogId, filtering, page, pageSize, fields);
        return resp.getData();
    }

    public ApiResponse<ProductSeriesGetResponse> productSeriesGetWithHttpInfo(Long accountId, Long catalogId, List<ProductSeriesSearchFilteringStruct> filtering, Long page, Long pageSize, List<String> fields) throws ApiException {
        Call call = this.productSeriesGetValidateBeforeCall(accountId, catalogId, filtering, page, pageSize, fields, null, null);
        Type localVarReturnType = new TypeToken<ProductSeriesGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call productSeriesGetAsync(Long accountId, Long catalogId, List<ProductSeriesSearchFilteringStruct> filtering, Long page, Long pageSize, List<String> fields, final ApiCallback<ProductSeriesGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.productSeriesGetValidateBeforeCall(accountId, catalogId, filtering, page, pageSize, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProductSeriesGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

